/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.spi.builder;

import java.util.ServiceLoader;
import javax.enterprise.inject.spi.builder.AnnotatedTypeBuilder;
import javax.enterprise.inject.spi.builder.BeanAttributesBuilder;
import javax.enterprise.inject.spi.builder.BeanBuilder;
import javax.enterprise.inject.spi.builder.BuildersProvider;
import javax.enterprise.inject.spi.builder.InjectionPointBuilder;
import javax.enterprise.inject.spi.builder.ObserverMethodBuilder;

public final class Builders {
    protected static volatile BuildersProvider buildersProvider = null;

    private Builders() {
    }

    public static <T> AnnotatedTypeBuilder<T> annotatedType(Class<T> type) {
        return Builders.provider().getAnnotatedTypeBuilder(type);
    }

    public static InjectionPointBuilder injectionPoint() {
        return Builders.provider().getInjectionPointBuilder();
    }

    public static <T> BeanAttributesBuilder<T> beanAttributes(Class<T> type) {
        return Builders.provider().getBeanAttributesBuilder(type);
    }

    public static <T> BeanBuilder<T> bean(Class<T> type) {
        return Builders.provider().getBeanBuilder(type);
    }

    public static <T> ObserverMethodBuilder<T> observerMethod(Class<T> type) {
        return Builders.provider().getObserverMethodBuilder(type);
    }

    private static BuildersProvider provider() {
        if (buildersProvider == null) {
            buildersProvider = Builders.findProvider();
        }
        return buildersProvider;
    }

    private static BuildersProvider findProvider() {
        ServiceLoader<BuildersProvider> providerLoader = ServiceLoader.load(BuildersProvider.class, Builders.class.getClassLoader());
        if (!providerLoader.iterator().hasNext()) {
            throw new IllegalStateException("Unable to locate BuildersProvider");
        }
        return providerLoader.iterator().next();
    }
}

