/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.Immutable;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.TypeBinding;
import org.jboss.xb.binding.UnmarshallingContext;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.introspection.FieldInfo;
import org.xml.sax.Attributes;

public class MappingObjectModelFactory
implements GenericObjectModelFactory {
    private static final Logger log = Logger.getLogger(MappingObjectModelFactory.class);
    private final Map elementToClassMapping = new HashMap();
    private final Map elementToFieldMapping = new HashMap();

    public void mapElementToClass(String element, Class cls) {
        ElementToClassMapping mapping = new ElementToClassMapping(element, cls);
        this.addElementToClassMapping(mapping);
        if (log.isTraceEnabled()) {
            log.trace((Object)mapping);
        }
    }

    public void mapElementToField(String element, Class cls, String field, TypeBinding converter) {
        ElementToFieldMapping mapping = new ElementToFieldMapping(element, cls, field, converter);
        this.addElementToFieldMapping(mapping);
        if (log.isTraceEnabled()) {
            log.trace((Object)mapping);
        }
    }

    public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("newRoot root=" + root + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs));
        }
        if (root == null) {
            ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
            if (mapping != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("creating root using " + mapping));
                }
                root = MappingObjectModelFactory.newInstance(mapping.cls);
            } else {
                root = MappingObjectModelFactory.create(namespaceURI, localName, ctx.getType());
            }
            if (root == null) {
                throw new IllegalStateException("Failed to resolve Java type binding for root element: ns=" + namespaceURI + ", local=" + localName);
            }
        }
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                try {
                    if (attrs.getLocalName(i).length() > 0 && !attrs.getQName(i).startsWith("xsi:")) {
                        this.setAttribute(root, attrs.getLocalName(i), attrs.getValue(i), ctx);
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to set attribute " + attrs.getQName(i) + "=" + attrs.getValue(i);
                    log.error((Object)msg, (Throwable)e);
                    throw new IllegalStateException(String.valueOf(msg) + ": " + e.getMessage());
                }
                ++i;
            }
        }
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newChild(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("newChild object=" + o + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs));
        }
        if (o == null) {
            throw new RuntimeException("Attempt to add a new child to a null parent localName=" + localName);
        }
        Object child = null;
        ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
        XSTypeDefinition type = ctx.getType();
        if (mapping != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("newChild using mapping " + mapping));
            }
            try {
                if (!(o instanceof Collection)) {
                    FieldInfo fieldInfo;
                    ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
                    if (fieldMapping != null) {
                        fieldInfo = fieldMapping.fieldInfo;
                    } else {
                        String fieldName = Util.xmlNameToFieldName(localName, true);
                        fieldInfo = FieldInfo.getFieldInfo(o.getClass(), fieldName, true);
                    }
                    child = MappingObjectModelFactory.get(o, localName, fieldInfo);
                }
                if (child == null) {
                    child = MappingObjectModelFactory.newInstance(mapping.cls);
                }
                if (attrs == null) return child;
                int i = 0;
                while (i < attrs.getLength()) {
                    if (attrs.getLocalName(i).length() > 0 && !attrs.getQName(i).startsWith("xsi:")) {
                        this.setAttribute(child, attrs.getLocalName(i), attrs.getValue(i), ctx);
                    }
                    ++i;
                }
                return child;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NestedRuntimeException("newChild failed for o=" + o + ", uri=" + namespaceURI + ", local=" + localName + ", attrs=" + attrs, (Throwable)e);
            }
        } else {
            String fieldName;
            if (o instanceof Collection) {
                return MappingObjectModelFactory.create(namespaceURI, localName, type);
            }
            Class oCls = o instanceof Immutable ? ((Immutable)o).cls : o.getClass();
            FieldInfo fieldInfo = FieldInfo.getFieldInfo(oCls, fieldName = Util.xmlNameToFieldName(localName, true), true);
            if (Collection.class.isAssignableFrom(fieldInfo.getType())) {
                child = MappingObjectModelFactory.get(o, localName, fieldInfo);
                Object item = null;
                if (type == null || type != null && type.getTypeCategory() == 15) {
                    item = MappingObjectModelFactory.create(namespaceURI, localName, type);
                }
                if (item != null) {
                    if (child != null) return item;
                    this.setChild(new ArrayList(), o, localName);
                    return item;
                }
                if (child != null) return child;
                return new ArrayList();
            }
            if (Util.isAttributeType(fieldInfo.getType())) return child;
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
            TypeBinding converter = fieldMapping == null ? null : fieldMapping.converter;
            if (converter != null) return child;
            return MappingObjectModelFactory.newInstance(fieldInfo.getType());
        }
    }

    public void addChild(Object parent, Object child, UnmarshallingContext ctx, String namespaceURI, String localName) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("addChild parent=" + parent + " child=" + child + " namespaceURI=" + namespaceURI + " localName=" + localName));
        }
        if (child instanceof Immutable) {
            child = ((Immutable)child).newInstance();
        }
        this.setChild(child, parent, localName);
    }

    public void setValue(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setValue object=" + o + " ctx=" + ctx + " namespaceURI=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        this.setAttribute(o, localName, value, ctx);
    }

    public Object completeRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("completeRoot root=" + root + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName));
        }
        if (root instanceof Immutable) {
            root = ((Immutable)root).newInstance();
        }
        return root;
    }

    private void addElementToClassMapping(ElementToClassMapping mapping) {
        this.elementToClassMapping.put(mapping.element, mapping);
    }

    private void addElementToFieldMapping(ElementToFieldMapping mapping) {
        this.elementToFieldMapping.put(mapping.key, mapping);
    }

    private void setChild(Object child, Object parent, String localName) {
        boolean trace = log.isTraceEnabled();
        Object value = child;
        if (parent instanceof Collection) {
            if (trace) {
                log.trace((Object)("Add " + value + " to collection " + parent));
            }
            ((Collection)parent).add(value);
        } else {
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, parent.getClass()));
            if (fieldMapping != null) {
                if (trace) {
                    log.trace((Object)("Add " + value + " to " + parent + " using field mapping " + fieldMapping));
                }
                MappingObjectModelFactory.set(parent, value, localName, fieldMapping.fieldInfo);
            } else {
                Class parentCls = parent instanceof Immutable ? ((Immutable)parent).cls : parent.getClass();
                String fieldName = Util.xmlNameToFieldName(localName, true);
                FieldInfo fieldInfo = FieldInfo.getFieldInfo(parentCls, fieldName, false);
                if (trace) {
                    log.trace((Object)("Add " + value + " to property " + fieldName + " of " + parentCls));
                }
                if (fieldInfo != null) {
                    if (!(child instanceof Collection) && Collection.class.isAssignableFrom(fieldInfo.getType())) {
                        Object o = MappingObjectModelFactory.get(parent, localName, fieldInfo);
                        Collection col = (Collection)o;
                        if (trace) {
                            log.trace((Object)("Add " + value + " to collection " + col + " retrieved from " + fieldName));
                        }
                        col.add(child);
                    } else {
                        MappingObjectModelFactory.set(parent, value, localName, fieldInfo);
                    }
                }
            }
        }
    }

    private void setAttribute(Object o, String localName, String value, UnmarshallingContext ctx) {
        if (o instanceof Collection) {
            XSTypeDefinition type = ctx.getType();
            if (type == null) {
                log.warn((Object)("Type is not available for collection item " + localName + "=" + value + " -> adding as string."));
                ((Collection)o).add(value);
            } else {
                if (type.getName() == null) {
                    throw new IllegalStateException("Name is null for simple type?!");
                }
                Object trgValue = SimpleTypeBindings.unmarshal(type.getName(), value, ctx.getNamespaceContext());
                ((Collection)o).add(trgValue);
            }
        } else {
            Object fieldValue = null;
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
            if (fieldMapping != null) {
                fieldValue = fieldMapping.converter.unmarshal(value);
                MappingObjectModelFactory.set(o, fieldValue, localName, fieldMapping.fieldInfo);
            } else {
                Class oCls = o instanceof Immutable ? ((Immutable)o).cls : o.getClass();
                String fieldName = Util.xmlNameToFieldName(localName, true);
                FieldInfo fieldInfo = FieldInfo.getFieldInfo(oCls, fieldName, true);
                fieldValue = SimpleTypeBindings.unmarshal(value, fieldInfo.getType());
                MappingObjectModelFactory.set(o, fieldValue, localName, fieldInfo);
            }
        }
    }

    private static Object create(String namespaceURI, String localName, XSTypeDefinition type) {
        Class<?> cls;
        Object o;
        block3: {
            o = null;
            String clsName = type != null && type.getName() != null ? Util.xmlNameToClassName(namespaceURI, type.getName(), true) : Util.xmlNameToClassName(namespaceURI, localName, true);
            cls = null;
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
            }
            catch (ClassNotFoundException e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)("create: failed to load class " + clsName));
            }
        }
        if (cls != null) {
            o = MappingObjectModelFactory.newInstance(cls);
        }
        return o;
    }

    private static Object get(Object o, String localName, FieldInfo fieldInfo) {
        Object value;
        if (log.isTraceEnabled()) {
            log.trace((Object)("get object=" + o + " localName=" + localName));
        }
        if (o instanceof Immutable) {
            Immutable con = (Immutable)o;
            value = con.getChild(localName);
        } else {
            value = fieldInfo.getValue(o);
        }
        return value;
    }

    private static void set(Object parent, Object child, String localName, FieldInfo fieldInfo) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("set parent=" + parent + " child=" + child + " localName=" + localName));
        }
        if (fieldInfo.isWritable()) {
            fieldInfo.setValue(parent, child);
        } else if (parent instanceof Immutable) {
            ((Immutable)parent).addChild(localName, child);
        } else {
            throw new IllegalStateException("Neither write method nor field were found for " + fieldInfo.getName() + " and the parent object is not an immutable container: parent=" + parent.getClass() + ", localName=" + localName + ", parent=" + parent + ", child=" + child);
        }
    }

    private static Object newInstance(Class cls) {
        Object instance;
        if (log.isTraceEnabled()) {
            log.trace((Object)("new " + cls.getName()));
        }
        try {
            Constructor ctor = cls.getConstructor(null);
            instance = ctor.newInstance(null);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)("No no-arg constructor in " + cls));
            instance = new Immutable(cls);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create an instance of " + cls + " with the no-arg constructor: " + e.getMessage());
        }
        return instance;
    }

    private class ElementToClassMapping {
        public final String element;
        public final Class cls;

        public ElementToClassMapping(String element, Class cls) {
            this.element = element;
            this.cls = cls;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ElementToClass@").append(System.identityHashCode(this));
            buffer.append("{element=").append(this.element);
            if (this.cls != null) {
                buffer.append(" class=").append(this.cls.getName());
            }
            buffer.append("}");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToClassMapping)) {
                return false;
            }
            ElementToClassMapping classMapping = (ElementToClassMapping)o;
            return !(this.cls != null ? !this.cls.equals(classMapping.cls) : classMapping.cls != null);
        }

        public int hashCode() {
            return this.cls != null ? this.cls.hashCode() : 0;
        }
    }

    private class ElementToFieldMappingKey {
        public final String element;
        public final Class cls;

        public ElementToFieldMappingKey(String element, Class cls) {
            this.element = element;
            this.cls = cls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToFieldMappingKey)) {
                return false;
            }
            ElementToFieldMappingKey elementToFieldMappingKey = (ElementToFieldMappingKey)o;
            if (this.cls != null ? !this.cls.equals(elementToFieldMappingKey.cls) : elementToFieldMappingKey.cls != null) {
                return false;
            }
            return !(this.element != null ? !this.element.equals(elementToFieldMappingKey.element) : elementToFieldMappingKey.element != null);
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
            return result;
        }
    }

    private class ElementToFieldMapping {
        public final String element;
        public final Class cls;
        public final TypeBinding converter;
        public final ElementToFieldMappingKey key;
        public final FieldInfo fieldInfo;

        public ElementToFieldMapping(String element, Class cls, String fieldName, TypeBinding converter) {
            this.element = element;
            this.cls = cls;
            this.converter = converter;
            this.key = new ElementToFieldMappingKey(element, cls);
            this.fieldInfo = FieldInfo.getFieldInfo(cls, fieldName, true);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ElementToField@").append(System.identityHashCode(this));
            buffer.append("{element=").append(this.element);
            if (this.cls != null) {
                buffer.append(" class=").append(this.cls.getName());
            }
            buffer.append(" field=").append(this.fieldInfo.getName());
            if (this.converter != null) {
                buffer.append(" convertor=").append(this.converter.getClass().getName());
            }
            buffer.append("}");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToFieldMapping)) {
                return false;
            }
            ElementToFieldMapping elementToFieldMapping = (ElementToFieldMapping)o;
            if (this.cls != null ? !this.cls.equals(elementToFieldMapping.cls) : elementToFieldMapping.cls != null) {
                return false;
            }
            if (this.element != null ? !this.element.equals(elementToFieldMapping.element) : elementToFieldMapping.element != null) {
                return false;
            }
            return this.fieldInfo.getName().equals(elementToFieldMapping.fieldInfo.getName());
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
            result = 29 * result + this.fieldInfo.getName().hashCode();
            return result;
        }
    }
}

