/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.group;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.util.Classes;
import org.jboss.xb.binding.GenericValueContainer;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.group.ValueList;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;

public interface ValueListHandler {
    public static final ValueListHandler IMMUTABLE = new ValueListHandler(){

        public Object newInstance(ParticleBinding particle, ValueList valueList) {
            Class cls = valueList.getTargetClass();
            Map map = valueList.getNonRequiredValues();
            Collection values = map.values();
            if (values.isEmpty()) {
                throw new JBossXBRuntimeException("Value list does not contain non-required values.");
            }
            Constructor<?> ctor = null;
            Constructor<?>[] ctors = cls.getConstructors();
            if (ctors == null || ctors.length == 0) {
                throw new JBossXBRuntimeException("The class has no declared constructors: " + cls);
            }
            int i = 0;
            while (i < ctors.length) {
                Class<?>[] types = ctors[i].getParameterTypes();
                if (types == null || types.length == 0) {
                    throw new IllegalStateException("Found no-arg constructor for immutable " + cls);
                }
                if (types.length == map.size()) {
                    ctor = ctors[i];
                    int typeInd = 0;
                    Iterator iter = values.iterator();
                    while (iter.hasNext()) {
                        Class type;
                        if ((type = types[typeInd++]).isPrimitive()) {
                            type = Classes.getPrimitiveWrapper(type);
                        }
                        if (type.isAssignableFrom(iter.next().getClass())) continue;
                        ctor = null;
                        break;
                    }
                    if (ctor != null) break;
                }
                ++i;
            }
            if (ctor == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("There is no ctor in ").append(cls).append(" that would take the following arguments:\n");
                int cnt = 0;
                for (Object o : values) {
                    buf.append(' ').append(++cnt).append(") ").append(o.getClass()).append(": ").append(o).append('\n');
                }
                throw new IllegalStateException(buf.toString());
            }
            try {
                return ctor.newInstance(values.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create immutable instance of " + cls + " using arguments: " + values + ": " + e.getMessage());
            }
        }
    };
    public static final ValueListHandler NON_DEFAULT_CTOR = new ValueListHandler(){

        public Object newInstance(ParticleBinding particle, ValueList valueList) {
            Object o;
            Class cls = valueList.getTargetClass();
            int size = valueList.size();
            if (size == 0) {
                try {
                    return this.newInstance(cls.getConstructor(null), null);
                }
                catch (NoSuchMethodException e) {
                    throw new JBossXBRuntimeException("Value list does not contain non-required values and there is no no-arg ctor in " + cls);
                }
            }
            Constructor ctor = this.matchBestCtor(cls, valueList);
            if (ctor == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("Failed to find no-arg ctor or best-match ctor in ").append(cls).append(", property values:\n");
                int cnt = 0;
                int i = 0;
                while (i < size) {
                    Object o2 = valueList.getValue((int)i).value;
                    buf.append(' ').append(++cnt).append(") ").append(o2).append('\n');
                    ++i;
                }
                throw new JBossXBRuntimeException(buf.toString());
            }
            int argsTotal = ctor.getParameterTypes().length;
            if (argsTotal == size) {
                Object[] args = this.getArgs(ctor, valueList);
                o = this.newInstance(ctor, args);
            } else {
                Object[] args = this.getArgs(ctor, valueList);
                o = this.newInstance(ctor, args);
                int i = argsTotal;
                while (i < size) {
                    ValueList.NonRequiredValue valueEntry = valueList.getValue(i++);
                    Object binding = valueEntry.binding;
                    if (binding instanceof ParticleBinding) {
                        Object handler = valueEntry.handler;
                        ParticleBinding childParticle = (ParticleBinding)binding;
                        if (handler instanceof ParticleHandler) {
                            ParticleHandler pHandler = (ParticleHandler)handler;
                            if (childParticle.isRepeatable()) {
                                TermBinding term = childParticle.getTerm();
                                if (!(o instanceof GenericValueContainer) && term.getAddMethodMetaData() == null && term.getMapEntryMetaData() == null && term.getPutMethodMetaData() == null) {
                                    pHandler.setParent(o, valueEntry.value, valueEntry.qName, childParticle, particle);
                                    continue;
                                }
                                Collection col = (Collection)valueEntry.value;
                                Iterator iter = col.iterator();
                                while (iter.hasNext()) {
                                    pHandler.setParent(o, iter.next(), valueEntry.qName, childParticle, particle);
                                }
                                continue;
                            }
                            pHandler.setParent(o, valueEntry.value, valueEntry.qName, childParticle, particle);
                            continue;
                        }
                        ((CharactersHandler)handler).setValue(valueEntry.qName, (ElementBinding)childParticle.getTerm(), o, valueEntry.value);
                        continue;
                    }
                    if (binding instanceof AttributeBinding) {
                        AttributeBinding attr = (AttributeBinding)binding;
                        AttributeHandler handler = attr.getHandler();
                        if (handler != null) {
                            handler.attribute(valueEntry.qName, attr.getQName(), attr, o, valueEntry.value);
                            continue;
                        }
                        throw new JBossXBRuntimeException("Attribute binding present but has no handler: element=" + valueEntry.qName + ", attrinute=" + attr.getQName());
                    }
                    throw new JBossXBRuntimeException("Unexpected binding type: " + binding);
                }
            }
            return o;
        }

        private Constructor matchBestCtor(Class cls, ValueList valueList) {
            Constructor<?> bestMatch = null;
            int bestMatchArgsTotal = 0;
            Constructor<?>[] ctors = cls.getConstructors();
            int size = valueList.size();
            int i = 0;
            while (i < ctors.length) {
                Constructor<?> ctor = ctors[i];
                Class<?>[] types = ctor.getParameterTypes();
                if ((types == null || types.length == 0) && bestMatch == null) {
                    bestMatch = ctor;
                } else if (bestMatchArgsTotal <= types.length) {
                    int typeInd = 0;
                    int valueInd = 0;
                    while (typeInd < types.length && valueInd < size) {
                        Class type = types[typeInd];
                        if (type.isPrimitive()) {
                            type = Classes.getPrimitiveWrapper(type);
                        }
                        ValueList.NonRequiredValue valueEntry = valueList.getValue(valueInd);
                        Object value = valueEntry.value;
                        if (value != null && !type.isAssignableFrom(value.getClass()) && (!(valueEntry.binding instanceof ParticleBinding) || !((ParticleBinding)valueEntry.binding).isRepeatable() || !type.isArray()) || bestMatchArgsTotal == types.length && !bestMatch.getParameterTypes()[typeInd].isAssignableFrom(type)) break;
                        ++typeInd;
                        ++valueInd;
                    }
                    if (typeInd == types.length) {
                        bestMatch = ctor;
                        bestMatchArgsTotal = types.length;
                    }
                }
                ++i;
            }
            return bestMatch;
        }

        private Object newInstance(Constructor bestMatch, Object[] args) {
            try {
                return bestMatch.newInstance(args);
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to create an instance of " + bestMatch.getDeclaringClass() + " using the following ctor arguments " + Arrays.asList(args), e);
            }
        }

        private Object[] getArgs(Constructor ctor, ValueList valueList) {
            Class<?>[] types = ctor.getParameterTypes();
            Object[] args = new Object[types.length];
            int i = 0;
            while (i < types.length) {
                ValueList.NonRequiredValue valueEntry = valueList.getValue(i);
                Object arg = valueEntry.value;
                if (valueEntry.value != null && !types[i].isAssignableFrom(arg.getClass()) && types[i].isArray() && Collection.class.isAssignableFrom(arg.getClass())) {
                    Collection col = (Collection)arg;
                    arg = Array.newInstance(types[i].getComponentType(), col.size());
                    int arrInd = 0;
                    Iterator iter = col.iterator();
                    while (iter.hasNext()) {
                        Array.set(arg, arrInd++, iter.next());
                    }
                }
                args[i] = arg;
                ++i;
            }
            return args;
        }
    };

    public Object newInstance(ParticleBinding var1, ValueList var2);

    public static class FACTORY {
        public static ValueListHandler lazy(final Object parent) {
            return new ValueListHandler(){
                private final ValueList parentValueList;
                {
                    this.parentValueList = object instanceof ValueList ? (ValueList)object : null;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object newInstance(ParticleBinding particle, ValueList valueList) {
                    int i = 0;
                    while (i < valueList.size()) {
                        ValueList.NonRequiredValue valueEntry = valueList.getValue(i);
                        Object binding = valueEntry.binding;
                        if (binding instanceof ParticleBinding) {
                            Object handler = valueEntry.handler;
                            ParticleBinding childParticle = (ParticleBinding)binding;
                            if (handler instanceof ParticleHandler) {
                                ParticleHandler pHandler = (ParticleHandler)handler;
                                if (childParticle.isRepeatable()) {
                                    if (this.parentValueList != null) {
                                        this.parentValueList.addTermValue(valueEntry.qName, childParticle, pHandler, valueEntry.value, null);
                                    } else {
                                        Collection col = (Collection)valueEntry.value;
                                        pHandler.setParent(parent, col, valueEntry.qName, childParticle, valueEntry.parentParticle);
                                    }
                                } else if (this.parentValueList != null) {
                                    this.parentValueList.addTermValue(valueEntry.qName, childParticle, pHandler, valueEntry.value, valueEntry.parentParticle);
                                } else {
                                    pHandler.setParent(parent, valueEntry.value, valueEntry.qName, childParticle, valueEntry.parentParticle);
                                }
                            } else {
                                CharactersHandler cHandler = (CharactersHandler)handler;
                                if (this.parentValueList != null) {
                                    this.parentValueList.addTextValue(valueEntry.qName, childParticle, cHandler, valueEntry.value);
                                } else {
                                    cHandler.setValue(valueEntry.qName, (ElementBinding)childParticle.getTerm(), parent, valueEntry.value);
                                }
                            }
                        } else {
                            if (!(binding instanceof AttributeBinding)) throw new JBossXBRuntimeException("Unexpected binding type: " + binding);
                            AttributeBinding attr = (AttributeBinding)binding;
                            AttributeHandler handler = attr.getHandler();
                            if (handler == null) throw new JBossXBRuntimeException("Attribute binding present but has no handler: element=" + valueEntry.qName + ", attrinute=" + attr.getQName());
                            if (this.parentValueList != null) {
                                this.parentValueList.setAttributeValue(attr.getQName(), attr, valueEntry.value);
                            } else {
                                handler.attribute(valueEntry.qName, attr.getQName(), attr, parent, valueEntry.value);
                            }
                        }
                        ++i;
                    }
                    return parent;
                }
            };
        }

        public static ValueListHandler child() {
            return new ValueListHandler(){

                public Object newInstance(ParticleBinding particle, ValueList valueList) {
                    if (valueList.size() > 1) {
                        String msg = "Expected only one child for " + particle.getTerm() + " but got:";
                        int i = 0;
                        while (i < valueList.size()) {
                            ValueList.NonRequiredValue valueEntry = valueList.getValue(0);
                            msg = String.valueOf(msg) + " " + valueEntry.value + ";";
                            ++i;
                        }
                        throw new JBossXBRuntimeException(msg);
                    }
                    ValueList.NonRequiredValue valueEntry = valueList.getValue(0);
                    return valueEntry.value;
                }
            };
        }
    }
}

