/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.impl.FileListOperations;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexOutput
extends IndexOutput {
    private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
    private static final boolean trace = log.isTraceEnabled();
    private final int bufferSize;
    private final Cache<ChunkCacheKey, Object> chunksCache;
    private final Cache<ChunkCacheKey, Object> chunksCacheForStorage;
    private final AdvancedCache<FileCacheKey, FileMetadata> metadataCache;
    private final FileMetadata file;
    private final FileCacheKey fileKey;
    private final FileListOperations fileOps;
    private final Checksum crc = new BufferedChecksum((Checksum)new CRC32());
    private byte[] buffer;
    private byte[] firstChunkBuffer;
    private int positionInBuffer = 0;
    private long filePosition = 0L;
    private int currentChunkNumber = 0;

    public InfinispanIndexOutput(AdvancedCache<FileCacheKey, FileMetadata> metadataCache, AdvancedCache<ChunkCacheKey, Object> chunksCache, FileCacheKey fileKey, int bufferSize, FileListOperations fileList) {
        super("InfinispanIndexOutput{metadataCache=" + metadataCache + ", chunksCache=" + chunksCache + ", fileKey=" + fileKey + ", bufferSize=" + bufferSize + '}');
        this.metadataCache = metadataCache;
        this.chunksCache = chunksCache;
        this.chunksCacheForStorage = chunksCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.fileKey = fileKey;
        this.bufferSize = bufferSize;
        this.fileOps = fileList;
        this.buffer = new byte[this.bufferSize];
        this.firstChunkBuffer = this.buffer;
        this.file = new FileMetadata(bufferSize);
        if (trace) {
            log.tracef("Opened new IndexOutput for file:%s in index: %s", (Object)fileKey.getFileName(), (Object)fileKey.getIndexName());
        }
    }

    private byte[] getChunkById(FileCacheKey fileKey, int chunkNumber, int bufferSize) {
        if (this.file.getNumberOfChunks() <= chunkNumber) {
            return new byte[bufferSize];
        }
        ChunkCacheKey key = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), chunkNumber, bufferSize);
        byte[] readBuffer = (byte[])this.chunksCache.get((Object)key);
        if (readBuffer == null) {
            return new byte[bufferSize];
        }
        if (readBuffer.length == bufferSize) {
            return readBuffer;
        }
        byte[] newBuffer = new byte[bufferSize];
        System.arraycopy(readBuffer, 0, newBuffer, 0, readBuffer.length);
        return newBuffer;
    }

    private static int getPositionInBuffer(long pos, int bufferSize) {
        return (int)(pos % (long)bufferSize);
    }

    private static int getChunkNumberFromPosition(long pos, int bufferSize) {
        return (int)(pos / (long)bufferSize);
    }

    private void newChunk() {
        this.storeCurrentBuffer(false);
        ++this.currentChunkNumber;
        this.buffer = this.getChunkById(this.fileKey, this.currentChunkNumber, this.bufferSize);
        this.positionInBuffer = 0;
    }

    public final void writeByte(byte b) {
        if (this.isNewChunkNeeded()) {
            this.newChunk();
        }
        this.crc.update(b);
        this.buffer[this.positionInBuffer++] = b;
        ++this.filePosition;
    }

    public final void writeBytes(byte[] b, int offset, int length) {
        int pieceLength;
        this.crc.update(b, offset, length);
        for (int writtenBytes = 0; writtenBytes < length; writtenBytes += pieceLength) {
            if (this.isNewChunkNeeded()) {
                this.newChunk();
            }
            pieceLength = Math.min(this.bufferSize - this.positionInBuffer, length - writtenBytes);
            System.arraycopy(b, offset + writtenBytes, this.buffer, this.positionInBuffer, pieceLength);
            this.positionInBuffer += pieceLength;
            this.filePosition += (long)pieceLength;
        }
    }

    private boolean isNewChunkNeeded() {
        return this.positionInBuffer == this.buffer.length;
    }

    public void flush() {
        this.storeCurrentBuffer(false);
    }

    protected void storeCurrentBuffer(boolean isClose) {
        int newBufferSize;
        if (this.currentChunkNumber == 0 && !isClose) {
            return;
        }
        this.resizeFileIfNeeded();
        byte[] bufferToFlush = this.buffer;
        boolean writingOnLastChunk = this.isWritingOnLastChunk();
        if (writingOnLastChunk && (newBufferSize = (int)(this.file.getSize() % (long)this.bufferSize)) != 0) {
            bufferToFlush = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, bufferToFlush, 0, newBufferSize);
        }
        if (!writingOnLastChunk || this.positionInBuffer != 0) {
            this.storeBufferAsChunk(bufferToFlush, this.currentChunkNumber);
        }
    }

    private void storeBufferAsChunk(byte[] bufferToFlush, int chunkNumber) {
        ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.fileKey.getFileName(), chunkNumber, this.bufferSize);
        if (trace) {
            log.tracef("Storing segment chunk: %s", (Object)key);
        }
        this.chunksCacheForStorage.put((Object)key, (Object)bufferToFlush);
    }

    private void resizeFileIfNeeded() {
        if (this.file.getSize() < this.filePosition) {
            this.file.setSize(this.filePosition);
        }
    }

    public void close() {
        if (this.currentChunkNumber == 0) {
            this.storeCurrentBuffer(true);
        } else {
            this.storeBufferAsChunk(this.firstChunkBuffer, 0);
            this.storeCurrentBuffer(true);
        }
        this.buffer = null;
        this.firstChunkBuffer = null;
        this.metadataCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)this.fileKey, (Object)this.file);
        this.fileOps.addFileName(this.fileKey.getFileName());
        if (trace) {
            log.tracef("Closed IndexOutput for %s", (Object)this.fileKey);
        }
    }

    public long getFilePointer() {
        return this.filePosition;
    }

    public void seek(long pos) throws IOException {
        int requestedChunkNumber = InfinispanIndexOutput.getChunkNumberFromPosition(pos, this.bufferSize);
        if (pos > this.file.getSize()) {
            this.resizeFileIfNeeded();
            if (pos > this.file.getSize()) {
                throw new IOException(this.fileKey.getFileName() + ": seeking past end of file");
            }
        }
        if (requestedChunkNumber != this.currentChunkNumber) {
            this.storeCurrentBuffer(false);
            this.buffer = requestedChunkNumber != 0 ? this.getChunkById(this.fileKey, requestedChunkNumber, this.bufferSize) : this.firstChunkBuffer;
            this.currentChunkNumber = requestedChunkNumber;
        }
        this.positionInBuffer = InfinispanIndexOutput.getPositionInBuffer(pos, this.bufferSize);
        this.filePosition = pos;
    }

    public long length() {
        this.resizeFileIfNeeded();
        return this.file.getSize();
    }

    private boolean isWritingOnLastChunk() {
        int lastChunkNumber = this.file.getNumberOfChunks() - 1;
        return this.currentChunkNumber >= lastChunkNumber;
    }

    public long getChecksum() throws IOException {
        return this.crc.getValue();
    }
}

