/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedSegmentReadLocker
implements SegmentReadLocker {
    private static final Log log = LogFactory.getLog(DistributedSegmentReadLocker.class);
    private final AdvancedCache<Object, Integer> locksCache;
    private final AdvancedCache<?, ?> chunksCache;
    private final AdvancedCache<FileCacheKey, FileMetadata> metadataCache;
    private final String indexName;
    private final boolean forceSynchronousDeletes;

    public DistributedSegmentReadLocker(Cache<Object, Integer> locksCache, Cache<?, ?> chunksCache, Cache<?, ?> metadataCache, String indexName) {
        this(locksCache, chunksCache, metadataCache, indexName, false);
    }

    public DistributedSegmentReadLocker(Cache<Object, Integer> locksCache, Cache<?, ?> chunksCache, Cache<?, ?> metadataCache, String indexName, boolean forceSynchronousDeletes) {
        this.forceSynchronousDeletes = forceSynchronousDeletes;
        if (locksCache == null) {
            throw new IllegalArgumentException("locksCache must not be null");
        }
        if (chunksCache == null) {
            throw new IllegalArgumentException("chunksCache must not be null");
        }
        if (metadataCache == null) {
            throw new IllegalArgumentException("metadataCache must not be null");
        }
        if (indexName == null) {
            throw new IllegalArgumentException("index name must not be null");
        }
        this.indexName = indexName;
        this.locksCache = locksCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.SKIP_INDEXING});
        this.chunksCache = chunksCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        this.metadataCache = metadataCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        DistributedSegmentReadLocker.verifyCacheHasNoEviction(this.locksCache);
    }

    public DistributedSegmentReadLocker(Cache<?, ?> cache, String indexName) {
        this(cache, cache, cache, indexName);
    }

    @Override
    public void deleteOrReleaseReadLock(String filename) {
        if (this.isMultiChunked(filename)) {
            int newValue = 0;
            FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
            boolean done = false;
            Object lockValue = this.locksCache.get((Object)readLockKey);
            while (!done) {
                if (lockValue == null) {
                    lockValue = this.locksCache.putIfAbsent((Object)readLockKey, (Object)0);
                    done = null == lockValue;
                    continue;
                }
                Integer refCountObject = (Integer)lockValue;
                int refCount = refCountObject;
                newValue = refCount - 1;
                done = this.locksCache.replace((Object)readLockKey, (Object)refCountObject, (Object)newValue);
                if (done) continue;
                lockValue = this.locksCache.get((Object)readLockKey);
            }
            if (newValue == 0) {
                DistributedSegmentReadLocker.realFileDelete(this.indexName, filename, this.locksCache, this.chunksCache, this.metadataCache, this.forceSynchronousDeletes);
            }
        } else {
            DistributedSegmentReadLocker.realFileDelete(this.indexName, filename, this.locksCache, this.chunksCache, this.metadataCache, this.forceSynchronousDeletes);
        }
    }

    private boolean isMultiChunked(String filename) {
        FileCacheKey fileCacheKey = new FileCacheKey(this.indexName, filename);
        FileMetadata fileMetadata = (FileMetadata)this.metadataCache.get((Object)fileCacheKey);
        if (fileMetadata == null) {
            return true;
        }
        return fileMetadata.isMultiChunked();
    }

    @Override
    public boolean acquireReadLock(String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
        Integer lockValue = (Integer)this.locksCache.get((Object)readLockKey);
        boolean done = false;
        while (!done) {
            FileCacheKey fileKey;
            if (lockValue != null) {
                int refCount = lockValue;
                if (refCount == 0) {
                    return false;
                }
                Integer newValue = refCount + 1;
                done = this.locksCache.replace((Object)readLockKey, (Object)lockValue, (Object)newValue);
                if (done) continue;
                lockValue = (Integer)this.locksCache.get((Object)readLockKey);
                continue;
            }
            lockValue = (Integer)this.locksCache.putIfAbsent((Object)readLockKey, (Object)2);
            done = null == lockValue;
            if (!done || this.metadataCache.get((Object)(fileKey = new FileCacheKey(this.indexName, filename))) != null) continue;
            this.locksCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).removeAsync((Object)readLockKey);
            return false;
        }
        return true;
    }

    static void realFileDelete(String indexName, String fileName, AdvancedCache<Object, Integer> locksCache, AdvancedCache<?, ?> chunksCache, AdvancedCache<?, ?> metadataCache, boolean forceSynchronousDeletes) {
        FileMetadata file;
        boolean trace = log.isTraceEnabled();
        FileCacheKey key = new FileCacheKey(indexName, fileName);
        if (trace) {
            log.tracef("deleting metadata: %s", (Object)key);
        }
        if ((file = (FileMetadata)metadataCache.remove((Object)key)) != null) {
            int bufferSize = file.getBufferSize();
            AdvancedCache chunksCacheNoReturn = chunksCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
            for (int i = 0; i < file.getNumberOfChunks(); ++i) {
                ChunkCacheKey chunkKey = new ChunkCacheKey(indexName, fileName, i, bufferSize);
                if (trace) {
                    log.tracef("deleting chunk: %s", (Object)chunkKey);
                }
                if (forceSynchronousDeletes) {
                    chunksCacheNoReturn.remove((Object)chunkKey);
                    continue;
                }
                chunksCacheNoReturn.removeAsync((Object)chunkKey);
            }
        }
        if (file != null && file.isMultiChunked()) {
            FileReadLockKey readLockKey = new FileReadLockKey(indexName, fileName);
            if (trace) {
                log.tracef("deleting readlock: %s", (Object)readLockKey);
            }
            if (forceSynchronousDeletes) {
                locksCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)readLockKey);
            } else {
                locksCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).removeAsync((Object)readLockKey);
            }
        }
    }

    private static void verifyCacheHasNoEviction(AdvancedCache<?, ?> cache) {
        if (cache.getCacheConfiguration().eviction().strategy().isEnabled()) {
            throw new IllegalArgumentException("DistributedSegmentReadLocker is not reliable when using a cache with eviction enabled, disable eviction on this cache instance");
        }
    }
}

