/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.util.concurrent.ConcurrentHashMap;

public class InterceptionMarkers {
    protected final ConcurrentHashMap<String, String> convertableReference = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> hasFieldInterception = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> hasConstructorInterception = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> skipConvertableReference = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> skipFieldInterception = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> skipConstructorInterception = new ConcurrentHashMap();

    public void addConstructionInterceptionMarker(String classname) {
        this.skipConstructorInterception.remove(classname);
        this.skipConvertableReference.remove(classname);
        this.hasConstructorInterception.put(classname, classname);
        this.convertableReference.put(classname, classname);
    }

    public void addFieldInterceptionMarker(String classname) {
        this.skipFieldInterception.remove(classname);
        this.skipConvertableReference.remove(classname);
        this.hasFieldInterception.put(classname, classname);
        this.convertableReference.put(classname, classname);
    }

    public void skipReference(String classname) {
        this.skipConvertableReference.put(classname, classname);
    }

    public boolean shouldSkipConstruction(String classname) {
        return !this.hasConstructorInterception.containsKey(classname) && this.skipConstructorInterception.containsKey(classname);
    }

    public boolean shouldSkipFieldAccess(String classname) {
        return !this.hasFieldInterception.containsKey(classname) && this.skipFieldInterception.containsKey(classname);
    }

    public void skipConstruction(String classname) {
        this.skipConstructorInterception.put(classname, classname);
    }

    public void skipFieldAccess(String classname) {
        this.skipFieldInterception.put(classname, classname);
    }

    public boolean convertReference(String classname) {
        return !this.skipConvertableReference.containsKey(classname) || this.convertableReference.containsKey(classname);
    }
}

