/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aop.expressions.ConstructorExpression;
import org.jboss.aop.expressions.MethodExpression;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.metadata.SimpleMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleClassMetaDataBinding
extends ClassMetaDataBinding {
    protected SimpleMetaData defaultMetaData = new SimpleMetaData();
    protected SimpleMetaData classMetaData = new SimpleMetaData();
    protected ArrayList<QueuedMethodMetaData> queuedMethodMetaData = new ArrayList();
    protected ArrayList<QueuedMetaData> queuedFieldMetaData = new ArrayList();
    protected ArrayList<QueuedConstructorMetaData> queuedConstructorMetaData = new ArrayList();

    public SimpleClassMetaDataBinding(ClassMetaDataLoader loader, String name, String tag, String expr) {
        super(loader, name, tag, expr);
    }

    public void addDefaultMetaData(String tag, String attr, Object value) {
        this.defaultMetaData.addMetaData(tag, attr, value);
    }

    public void addClassMetaData(String tag, String attr, Object value) {
        this.classMetaData.addMetaData(tag, attr, value);
    }

    public void queueMethodMetaData(String methodExpr, String tag, String attr, Object value) {
        this.queuedMethodMetaData.add(new QueuedMethodMetaData(methodExpr, tag, attr, value));
    }

    public ArrayList<QueuedMethodMetaData> getQueuedMethodMetaData() {
        return this.queuedMethodMetaData;
    }

    public void queueFieldMetaData(String fieldExpr, String tag, String attr, Object value) {
        this.queuedFieldMetaData.add(new QueuedMetaData(fieldExpr, tag, attr, value));
    }

    public ArrayList<QueuedMetaData> getQueuedFieldMetaData() {
        return this.queuedFieldMetaData;
    }

    public void queueConstructorMetaData(String constructorExpr, String tag, String attr, Object value) {
        this.queuedConstructorMetaData.add(new QueuedConstructorMetaData(constructorExpr, tag, attr, value));
    }

    public ArrayList<QueuedConstructorMetaData> getQueuedConstructorMetaData() {
        return this.queuedConstructorMetaData;
    }

    public SimpleMetaData getDefaultMetaData() {
        return this.defaultMetaData;
    }

    public SimpleMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public class QueuedConstructorMetaData {
        public ConstructorExpression expr;
        public String tag;
        public String attr;
        public Object value;

        public QueuedConstructorMetaData(String expr, String tag, String attr, Object value) {
            this.expr = new ConstructorExpression(expr);
            this.tag = tag;
            this.attr = attr;
            this.value = value;
        }
    }

    public class QueuedMethodMetaData {
        public MethodExpression expr;
        public String tag;
        public String attr;
        public Object value;

        public QueuedMethodMetaData(String expr, String tag, String attr, Object value) {
            this.expr = new MethodExpression(expr);
            this.tag = tag;
            this.attr = attr;
            this.value = value;
        }
    }

    public class QueuedMetaData {
        protected Pattern expr;
        public String tag;
        public String attr;
        public Object value;

        public QueuedMetaData(String exp, String tag, String attr, Object value) {
            exp = exp.replaceAll("\\.", "\\\\.");
            exp = exp.replaceAll("\\*", ".*");
            this.expr = Pattern.compile(exp);
            this.tag = tag;
            this.attr = attr;
            this.value = value;
        }

        public String getExpr() {
            return this.expr.toString();
        }

        public boolean matches(String match) {
            Matcher m = this.expr.matcher(match);
            return m.matches();
        }
    }
}

