/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.impl.DeployableTestBuilder;
import org.jboss.arquillian.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunnerAdaptor;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arquillian
extends BlockJUnit4ClassRunner {
    public static ThreadLocal<Throwable> caughtTestException = new ThreadLocal();
    private static ThreadLocal<Arquillian> lastCreatedRunner = new ThreadLocal();
    private static ThreadLocal<TestRunnerAdaptor> deployableTest = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Arquillian(Class<?> klass) throws InitializationError {
        block6: {
            super(klass);
            try {
                if (deployableTest.get() != null) break block6;
                if (lastCreatedRunner.get() != null) {
                    throw new RuntimeException("Arquillian has previously been attempted initialized, but failed. See previous exceptions for cause.");
                }
                TestRunnerAdaptor adaptor = DeployableTestBuilder.build();
                try {
                    adaptor.beforeSuite();
                    deployableTest.set(adaptor);
                }
                catch (Exception e) {
                    throw new InitializationError(Arrays.asList(e));
                }
            }
            finally {
                lastCreatedRunner.set(this);
            }
        }
    }

    public void run(RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testRunFinished(Result result) throws Exception {
                try {
                    if (deployableTest.get() != null && lastCreatedRunner.get() == Arquillian.this) {
                        ((TestRunnerAdaptor)deployableTest.get()).afterSuite();
                        ((TestRunnerAdaptor)deployableTest.get()).shutdown();
                        lastCreatedRunner.set(null);
                        lastCreatedRunner.remove();
                        deployableTest.set(null);
                        deployableTest.remove();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not run @AfterSuite", e);
                }
            }
        });
        super.run(notifier);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return super.computeTestMethods();
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected Statement withBeforeClasses(final Statement originalStatement) {
        final Statement onlyBefores = super.withBeforeClasses((Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                ((TestRunnerAdaptor)deployableTest.get()).beforeClass(Arquillian.this.getTestClass().getJavaClass(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyBefores));
                originalStatement.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(final Statement originalStatement) {
        final Statement onlyAfters = super.withAfterClasses((Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.multiExecute(new Statement[]{originalStatement, new Statement(){

                    public void evaluate() throws Throwable {
                        ((TestRunnerAdaptor)deployableTest.get()).afterClass(Arquillian.this.getTestClass().getJavaClass(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyAfters));
                    }
                }});
            }
        };
    }

    protected Statement withBefores(final FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyBefores = super.withBefores(method, target, (Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                ((TestRunnerAdaptor)deployableTest.get()).before(target, method.getMethod(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyBefores));
                originalStatement.evaluate();
            }
        };
    }

    protected Statement withAfters(final FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyAfters = super.withAfters(method, target, (Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.multiExecute(new Statement[]{originalStatement, new Statement(){

                    public void evaluate() throws Throwable {
                        ((TestRunnerAdaptor)deployableTest.get()).after(target, method.getMethod(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyAfters));
                    }
                }});
            }
        };
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestResult result = ((TestRunnerAdaptor)deployableTest.get()).test(new TestMethodExecutor(){

                    public void invoke(Object ... parameters) throws Throwable {
                        try {
                            method.invokeExplosively(test, parameters);
                        }
                        catch (Throwable e) {
                            caughtTestException.set(e);
                            throw e;
                        }
                    }

                    public Method getMethod() {
                        return method.getMethod();
                    }

                    public Object getInstance() {
                        return test;
                    }
                });
                if (result.getThrowable() != null) {
                    throw result.getThrowable();
                }
            }
        };
    }

    private void multiExecute(Statement ... statements) throws Throwable {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Statement command : statements) {
            try {
                command.evaluate();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        if (exceptions.size() == 1) {
            throw (Throwable)exceptions.get(0);
        }
        throw new MultipleFailureException(exceptions);
    }

    private static class StatementLifecycleExecutor
    implements LifecycleMethodExecutor {
        private Statement statement;

        public StatementLifecycleExecutor(Statement statement) {
            this.statement = statement;
        }

        public void invoke() throws Throwable {
            this.statement.evaluate();
        }
    }

    private static class EmptyStatement
    extends Statement {
        private EmptyStatement() {
        }

        public void evaluate() throws Throwable {
        }
    }
}

