/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public final class ArquillianHelper {
    private ArquillianHelper() {
    }

    public static URL getArtifactURL(String artifactId) {
        return ArquillianHelper.getArtifactURL(null, artifactId, null);
    }

    public static URL getArtifactURL(String groupId, String artifactId, String version) {
        File file;
        String archiveDir;
        String classPath;
        if (artifactId == null) {
            throw new IllegalArgumentException("Null artifactId");
        }
        String groupPath = null;
        if (groupId != null) {
            groupPath = groupId.replace('.', File.separatorChar);
        }
        if ((classPath = System.getProperty("java.class.path")) != null) {
            String[] paths;
            for (String path : paths = classPath.split("" + File.pathSeparatorChar)) {
                boolean groupMatch = groupPath == null || path.contains(File.separatorChar + groupPath + File.separator);
                boolean artifactMatch = path.contains(File.separatorChar + artifactId + File.separator);
                if (!groupMatch || !artifactMatch) continue;
                return ArquillianHelper.failsafeURL(path);
            }
        }
        if ((archiveDir = System.getProperty("test.archive.directory")) != null && (file = new File(archiveDir + File.separator + artifactId + ".jar")).exists()) {
            return ArquillianHelper.failsafeURL(file.getAbsolutePath());
        }
        String userHome = System.getProperty("user.home");
        File repositoryDir = new File(userHome + File.separator + ".m2" + File.separator + "repository");
        File groupDir = new File(repositoryDir + File.separator + groupPath);
        if (groupDir.exists() && version != null) {
            String pathname = groupDir + File.separator + artifactId + File.separator;
            File file2 = new File(pathname = pathname + version + File.separator + artifactId + "-" + version + ".jar");
            if (file2.exists()) {
                return ArquillianHelper.failsafeURL(file2.getAbsolutePath());
            }
        }
        return null;
    }

    private static URL failsafeURL(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            try {
                File file = new File(path);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            throw new IllegalArgumentException("Invalid path: " + path);
        }
    }
}

