/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.util;

import org.jboss.arquillian.spi.TestRunner;
import org.jboss.arquillian.spi.util.SecurityActions;
import org.jboss.arquillian.spi.util.ServiceLoader;

public final class TestRunners {
    private TestRunners() {
    }

    public static TestRunner getTestRunner() {
        return TestRunners.getTestRunner(SecurityActions.getThreadContextClassLoader());
    }

    public static TestRunner getTestRunner(ClassLoader classLoader) {
        ServiceLoader<TestRunner> serviceLoader = ServiceLoader.load(TestRunner.class, classLoader);
        if (serviceLoader.getProviders().size() > 1) {
            throw new IllegalStateException("Multiple TestRunners found, only one allowed. Check your classpath");
        }
        return serviceLoader.iterator().next();
    }
}

