/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.arquillian.container.spi;

/**
 * ServerKillProcessor
 * <p>
 * Implementations can be used to manually kill container instances from within
 * Container. As opposed to start/stop methods of Container,
 * this is dedicated for hard-kill of server instances.
 *
 * @author <a href="mailto:mgencur@redhat.com">Martin Gencur</a>
 * @version $Revision: $
 */
public interface ServerKillProcessor {

    /**
     * Kill a server instance via a specific implementation.
     */
    void kill(Container container) throws Exception;
}
