/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.configuration.CapabilityTypeMapper;
import org.jboss.arquillian.drone.configuration.SecurityActions;
import org.jboss.arquillian.drone.configuration.legacy.LegacyConfigurationMapper;
import org.jboss.arquillian.drone.configuration.mapping.BooleanValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.DoubleValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.IntegerValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.LongValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.StringValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.URIValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.URLValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.ValueMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationMapper {
    private static final Logger log = Logger.getLogger(ConfigurationMapper.class.getName());
    public static final List<ValueMapper<?>> VALUE_MAPPERS = new ArrayList();

    private ConfigurationMapper() {
        throw new InstantiationError();
    }

    public static <T extends DroneConfiguration<T>> T fromArquillianDescriptor(ArquillianDescriptor descriptor, T configuration, Class<? extends Annotation> qualifier) {
        Validate.notNull((Object)descriptor, (String)"Descriptor must not be null");
        Validate.notNull(configuration, (String)"Configuration object must not be null");
        Validate.notNull(qualifier, (String)"Qualifier object must not be null");
        String descriptorQualifier = configuration.getConfigurationName();
        String qualifierName = qualifier.getSimpleName().toLowerCase();
        Map<String, String> nameValuePairs = ConfigurationMapper.loadNameValuePairs(descriptor, descriptorQualifier, qualifierName);
        return ConfigurationMapper.mapFromNameValuePairs(configuration, nameValuePairs);
    }

    @Deprecated
    public static <T extends DroneConfiguration<T>> T fromSystemConfiguration(T configuration, Class<? extends Annotation> qualifier) {
        Validate.notNull(configuration, (String)"Configuration object must not be null");
        Validate.notNull(qualifier, (String)"Qualifier object must not be null");
        String descriptorQualifier = configuration.getConfigurationName();
        String qualifierName = qualifier.getSimpleName().toLowerCase();
        Map<String, String> nameValuePairs = ConfigurationMapper.loadNameValuePairs(descriptorQualifier, qualifierName);
        return ConfigurationMapper.mapFromNameValuePairs(configuration, nameValuePairs);
    }

    static <T extends DroneConfiguration<T>> T mapFromNameValuePairs(T configuration, Map<String, String> nameValuePairs) {
        Map<String, Field> fields = SecurityActions.getAccessableFields(configuration.getClass());
        List<Field> maps = SecurityActions.getMapFields(configuration.getClass(), String.class, Object.class);
        for (Field field : maps) {
            try {
                HashMap map = (HashMap)field.get(configuration);
                if (map == null) {
                    map = new HashMap();
                }
                field.set(configuration, map);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not map Drone configuration(" + configuration.getConfigurationName() + ") for " + configuration.getClass().getName() + " from Arquillian Descriptor", e);
            }
        }
        for (Map.Entry entry : nameValuePairs.entrySet()) {
            String name = (String)entry.getKey();
            if (fields.containsKey(name)) {
                ConfigurationMapper.injectField(configuration, maps, fields, name, (String)entry.getValue());
                continue;
            }
            if (fields.containsKey(ConfigurationMapper.keyTransformReverse(name))) {
                log.log(Level.WARNING, "The system property \"{0}\" used in Arquillian \"{1}\" configuration is deprecated, please rather use new format \"{2}\"", new Object[]{name, configuration.getConfigurationName(), ConfigurationMapper.keyTransformReverse(name)});
                ConfigurationMapper.injectField(configuration, maps, fields, ConfigurationMapper.keyTransformReverse(name), (String)entry.getValue());
                continue;
            }
            ConfigurationMapper.injectMapProperty(configuration, maps, fields, name, (String)entry.getValue());
        }
        return configuration;
    }

    static Map<String, String> loadNameValuePairs(ArquillianDescriptor descriptor, String descriptorQualifier, String qualifierName) {
        String fullDescriptorQualifier = descriptorQualifier + "-" + qualifierName;
        ExtensionDef match = null;
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (fullDescriptorQualifier.equals(extension.getExtensionName())) {
                Map nameValuePairs = extension.getExtensionProperties();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Using <extension qualifier=\"" + extension.getExtensionName() + "\"> for Drone Configuration");
                }
                return nameValuePairs;
            }
            if (!descriptorQualifier.equals(extension.getExtensionName())) continue;
            match = extension;
        }
        if (match != null) {
            Map nameValuePairs = match.getExtensionProperties();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Using <extension qualifier=\"" + match.getExtensionName() + "\"> for Drone Configuration");
            }
            return nameValuePairs;
        }
        return Collections.emptyMap();
    }

    @Deprecated
    static Map<String, String> loadNameValuePairs(String descriptorQualifier, String qualifierName) {
        String fullQualifiedPrefix = "arquillian." + descriptorQualifier + "." + qualifierName + ".";
        String qualifiedPrefix = "arquillian." + descriptorQualifier + ".";
        Map<String, String> candidates = SecurityActions.getProperties(fullQualifiedPrefix);
        if (candidates.isEmpty()) {
            candidates.putAll(SecurityActions.getProperties(qualifiedPrefix));
        }
        HashMap<String, String> nameValuePairs = new HashMap<String, String>(candidates.size());
        for (Map.Entry<String, String> entry : candidates.entrySet()) {
            String name = entry.getKey();
            if (log.isLoggable(Level.WARNING)) {
                String propertyName = name.contains(fullQualifiedPrefix) ? name.substring(fullQualifiedPrefix.length()) : name.substring(qualifiedPrefix.length());
                String newSysPropertyKey = "arq.extension." + (name.contains(fullQualifiedPrefix) ? descriptorQualifier + "-" + qualifierName : descriptorQualifier) + "." + propertyName;
                log.log(Level.WARNING, "Old system property format \"{0}\" is deprecated. You should use \"{1}\" instead.", new Object[]{name, newSysPropertyKey});
            }
            name = name.contains(fullQualifiedPrefix) ? name.substring(fullQualifiedPrefix.length()) : name.substring(qualifiedPrefix.length());
            nameValuePairs.put(name, entry.getValue());
        }
        return nameValuePairs;
    }

    static String keyTransformReverse(String propertyName) {
        StringBuilder sb = new StringBuilder();
        boolean upperCaseFlag = false;
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (c == '.') {
                upperCaseFlag = true;
                continue;
            }
            if (upperCaseFlag && Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                upperCaseFlag = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static <T extends DroneConfiguration<T>> Field injectField(T configuration, List<Field> maps, Map<String, Field> fields, String fieldName, String value) {
        try {
            Field f = fields.get(fieldName);
            if (f.getAnnotation(Deprecated.class) != null) {
                log.log(Level.WARNING, "The property \"{0}\" used in Arquillian \"{1}\" configuration is deprecated.", new Object[]{f.getName(), configuration.getConfigurationName()});
            }
            if (LegacyConfigurationMapper.isLegacy(fieldName)) {
                String newKey = LegacyConfigurationMapper.remapKey(fieldName);
                String newValue = LegacyConfigurationMapper.remapValue(fieldName, value);
                if (LegacyConfigurationMapper.remapsToCapability(fieldName)) {
                    ConfigurationMapper.injectMapProperty(configuration, maps, fields, newKey, newValue);
                } else {
                    ConfigurationMapper.injectField(configuration, maps, fields, newKey, newValue);
                }
            }
            f.set(configuration, ConfigurationMapper.convert(f.getType(), value));
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not map Drone configuration(" + configuration.getConfigurationName() + ") for " + configuration.getClass().getName() + " from Arquillian Descriptor", e);
        }
    }

    static <T extends DroneConfiguration<T>> void injectMapProperty(T configuration, List<Field> maps, Map<String, Field> fields, String propertyName, String value) {
        try {
            for (Field mapField : maps) {
                Object typedValue = value;
                if (CapabilityTypeMapper.isCastNeeded(propertyName)) {
                    typedValue = CapabilityTypeMapper.createTypedObjectFromString(propertyName, value);
                }
                Map map = (Map)mapField.get(configuration);
                map.put(propertyName, typedValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not map Drone configuration(" + configuration.getConfigurationName() + ") for " + configuration.getClass().getName() + " from Arquillian Descriptor", e);
        }
    }

    static Object convert(Class<?> clazz, String value) {
        for (ValueMapper<?> mapper : VALUE_MAPPERS) {
            if (!mapper.handles(clazz, new Class[0])) continue;
            return mapper.transform(value);
        }
        throw new IllegalArgumentException("Unable to convert value " + value + "to a class: " + clazz.getName());
    }

    static {
        VALUE_MAPPERS.add(BooleanValueMapper.INSTANCE);
        VALUE_MAPPERS.add(DoubleValueMapper.INSTANCE);
        VALUE_MAPPERS.add(IntegerValueMapper.INSTANCE);
        VALUE_MAPPERS.add(LongValueMapper.INSTANCE);
        VALUE_MAPPERS.add(StringValueMapper.INSTANCE);
        VALUE_MAPPERS.add(URIValueMapper.INSTANCE);
        VALUE_MAPPERS.add(URLValueMapper.INSTANCE);
    }
}

