/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jboss.arquillian.drone.configuration.mapping.ValueMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MapValueMapper implements ValueMapper<Map<String, String>>
{
    INSTANCE;


    @Override
    public boolean handles(Class<?> type, Class<?> ... parameters) {
        if (!Map.class.isAssignableFrom(type)) {
            return false;
        }
        if (parameters.length != 2) {
            return false;
        }
        for (Class<?> param : parameters) {
            if (param.equals(String.class)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> transform(String value) throws IllegalArgumentException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                StringTokenizer subSt = new StringTokenizer(st.nextToken().trim(), "=");
                map.put(subSt.nextToken().trim(), subSt.nextToken().trim());
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid format of '" + value + "', cannot be parsed to Map<String,String>. The expected format is 'key=value,key1=value1,key2=value2'", e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid format of '" + value + "', cannot be parsed to Map<String,String>. The expected format is 'key=value,key1=value1,key2=value2'", e);
        }
        return map;
    }
}

