/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.configuration;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverConfiguration
implements DroneConfiguration<WebDriverConfiguration> {
    private static final Logger log = Logger.getLogger(WebDriverConfiguration.class.getName());
    public static final String CONFIGURATION_NAME = "webdriver";
    public static URL DEFAULT_REMOTE_URL;
    public static final String DEFAULT_BROWSER_CAPABILITIES;
    private int iePort;
    private String ieDriverBinary;
    private String chromeDriverBinary;
    private URL remoteAddress;
    private String browser;
    private boolean remoteReusable;
    private boolean remote;
    private boolean reuseCookies;
    private String dimensions;
    private Map<String, Object> capabilityMap;
    private String _originalBrowser;
    private BrowserCapabilities _browser;

    public WebDriverConfiguration(BrowserCapabilities browser) {
        if (browser != null) {
            this._browser = browser;
            this.browser = this._originalBrowser = browser.getReadableName();
        }
    }

    public void setBrowserInternal(BrowserCapabilities browser) {
        if (browser != null) {
            this._browser = browser;
            this.browser = browser.getReadableName();
        }
    }

    public WebDriverConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
        if (this._originalBrowser != null && !this._originalBrowser.equals(this.browser)) {
            log.log(Level.WARNING, "Arquillian configuration is specifying a Drone of type {0}, however test class specifically asked for {1}. As Drone cannot guarantee that those two are compatible, \"browser\" property will be set to {1}.", new Object[]{this.browser, this._originalBrowser});
            this.browser = this._originalBrowser;
        }
        return this;
    }

    public String getBrowser() {
        if (this._browser != null) {
            return this._browser.getReadableName();
        }
        return this.browser;
    }

    public Capabilities getCapabilities() {
        return new DesiredCapabilities(new Capabilities[]{new DesiredCapabilities(this._browser.getRawCapabilities() == null ? new HashMap() : this._browser.getRawCapabilities()), new DesiredCapabilities(this.capabilityMap)});
    }

    public String getChromeDriverBinary() {
        return this.chromeDriverBinary;
    }

    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }

    public int getIePort() {
        return this.iePort;
    }

    public String getIeDriverBinary() {
        return this.ieDriverBinary;
    }

    public String getImplementationClass() {
        return this._browser.getImplementationClassName();
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isRemoteReusable() {
        return this.remoteReusable;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public void setChromeDriverBinary(String chromeDriverBinary) {
        this.chromeDriverBinary = chromeDriverBinary;
    }

    public void setIePort(int iePort) {
        this.iePort = iePort;
    }

    public void setIeDriverBinary(String ieDriverBinary) {
        this.ieDriverBinary = ieDriverBinary;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setRemoteAddress(URL remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRemoteReusable(boolean remoteReusable) {
        this.remoteReusable = remoteReusable;
    }

    public boolean isReuseCookies() {
        return this.reuseCookies;
    }

    public void setReuseCookies(boolean reuseCookies) {
        this.reuseCookies = reuseCookies;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    static {
        try {
            DEFAULT_REMOTE_URL = new URL("http://localhost:14444/wd/hub");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        DEFAULT_BROWSER_CAPABILITIES = new BrowserCapabilitiesList.HtmlUnit().getReadableName();
    }
}

