/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromeDriverFactory
extends AbstractWebDriverFactory<ChromeDriver>
implements Configurator<ChromeDriver, WebDriverConfiguration>,
Instantiator<ChromeDriver, WebDriverConfiguration>,
Destructor<ChromeDriver> {
    private static final Logger log = Logger.getLogger(ChromeDriverFactory.class.getName());
    private static final String CHROME_DRIVER_BINARY_KEY = "webdriver.chrome.driver";
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Chrome().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(ChromeDriver instance) {
        instance.quit();
    }

    public ChromeDriver createInstance(WebDriverConfiguration configuration) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String driverBinary = configuration.getChromeDriverBinary();
        String binary = (String)capabilities.getCapability("chrome.binary");
        String chromeSwitches = (String)capabilities.getCapability("chrome.switches");
        if (Validate.empty(driverBinary)) {
            driverBinary = SecurityActions.getProperty(CHROME_DRIVER_BINARY_KEY);
        }
        if (Validate.nonEmpty(driverBinary)) {
            Validate.isExecutable(driverBinary, "Chrome driver binary must point to an executable file, " + driverBinary);
            SecurityActions.setProperty(CHROME_DRIVER_BINARY_KEY, driverBinary);
        }
        if (Validate.nonEmpty(binary)) {
            Validate.isExecutable(binary, "Chrome binary must point to an executable file, " + binary);
            ChromeOptions chromeOptions = new ChromeOptions();
            chromeOptions.setBinary(binary);
            capabilities.setCapability("chromeOptions", (Object)chromeOptions);
        }
        if (Validate.nonEmpty(chromeSwitches)) {
            capabilities.setCapability("chrome.switches", this.getChromeSwitches(chromeSwitches));
        }
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, ChromeDriver.class);
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }

    @Override
    public WebDriverConfiguration createConfiguration(ArquillianDescriptor descriptor, DronePoint<ChromeDriver> dronePoint) {
        DroneConfiguration configuration = super.createConfiguration(descriptor, (DronePoint)dronePoint);
        if (!configuration.isRemote()) {
            configuration.setRemote(true);
            log.log(Level.FINE, "Forcing ChromeDriver configuration to be remote-based.");
        }
        return configuration;
    }

    private List<String> getChromeSwitches(String valueString) {
        ArrayList<String> chromeSwitches = new ArrayList<String>();
        for (String property : StringUtils.tokenize(valueString)) {
            if (!property.startsWith("--")) continue;
            chromeSwitches.add(property);
        }
        return chromeSwitches;
    }
}

