/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.phantom.resolver;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openqa.selenium.Platform;

public class FileUtils {
    private static final FileExecutableChecker fileExecutableChecker = new FileExecutableChecker();
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final ImmutableSet<String> ENDINGS = Platform.getCurrent().is(Platform.WINDOWS) ? ImmutableSet.of((Object)"", (Object)".cmd", (Object)".exe", (Object)".com", (Object)".bat") : ImmutableSet.of((Object)"");

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(ZipFile jar, String filename, File destination) throws IOException {
        ZipEntry entry = jar.getEntry(filename);
        if (entry == null) {
            throw new FileNotFoundException("cannot find file: " + filename + " in archive: " + jar.getName());
        }
        InputStream zipStream = jar.getInputStream(entry);
        FileOutputStream fileStream = null;
        try {
            fileStream = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = zipStream.read(buf)) != -1) {
                ((OutputStream)fileStream).write(buf, 0, i);
            }
        }
        finally {
            FileUtils.close(zipStream);
            FileUtils.close(fileStream);
        }
        return destination;
    }

    public static void close(Closeable stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    public static void setExecutable(File file) throws IOException {
        if (FileUtils.isUnix()) {
            try {
                ProcessBuilder pb = new ProcessBuilder("chmod", "+x", file.getAbsolutePath());
                int exitCode = pb.start().waitFor();
                if (exitCode != 0) {
                    throw new IOException("Unable to set executable flag on " + file.getAbsolutePath() + ". Exit code was " + exitCode);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0 || "mac os x".equals(OS);
    }

    public static boolean isExecutable(File file) throws IllegalArgumentException {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("The file %s does not exist", file));
        }
        return fileExecutableChecker.canExecute(file);
    }

    public static boolean isExecutable(String command) throws IllegalArgumentException {
        File file = new File(command);
        if (fileExecutableChecker.canExecute(file)) {
            return true;
        }
        if (Platform.getCurrent().is(Platform.WINDOWS) && fileExecutableChecker.canExecute(file = new File(command + ".exe"))) {
            return true;
        }
        ImmutableSet.Builder pathSegmentBuilder = new ImmutableSet.Builder();
        FileUtils.addPathFromEnvironment((ImmutableSet.Builder<String>)pathSegmentBuilder);
        if (Platform.getCurrent().is(Platform.MAC)) {
            FileUtils.addMacSpecificPath((ImmutableSet.Builder<String>)pathSegmentBuilder);
        }
        for (String pathSegment : pathSegmentBuilder.build()) {
            for (String ending : ENDINGS) {
                file = new File(pathSegment, command + ending);
                if (!fileExecutableChecker.canExecute(file)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addPathFromEnvironment(ImmutableSet.Builder<String> pathSegmentBuilder) {
        String path;
        String pathName = "PATH";
        Map<String, String> env = System.getenv();
        if (!env.containsKey(pathName)) {
            for (String key : env.keySet()) {
                if (!pathName.equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        if ((path = env.get(pathName)) != null) {
            pathSegmentBuilder.add((Object[])path.split(File.pathSeparator));
        }
    }

    private static void addMacSpecificPath(ImmutableSet.Builder<String> pathSegmentBuilder) {
        File pathFile = new File("/etc/paths");
        if (pathFile.exists()) {
            try {
                pathSegmentBuilder.addAll((Iterable)Files.readLines((File)pathFile, (Charset)Charsets.UTF_8));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class FileExecutableChecker {
        private static final Logger log = Logger.getLogger(FileExecutableChecker.class.getName());
        private final Method isExecutableMethod;

        FileExecutableChecker() {
            Method m = null;
            try {
                m = File.class.getMethod("canExecute", new Class[0]);
            }
            catch (SecurityException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            this.isExecutableMethod = m;
        }

        public boolean canExecute(File file) {
            if (this.isExecutableMethod == null) {
                return true;
            }
            Boolean result = true;
            try {
                result = (Boolean)this.isExecutableMethod.invoke((Object)file, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            return result;
        }
    }
}

