/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.container;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.arquillian.spring.integration.container.SecurityActions;
import org.jboss.arquillian.spring.integration.context.AbstractApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.RemoteTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.test.annotation.SpringContextConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;

public class CustomRemoteApplicationContextProducer
extends AbstractApplicationContextProducer {
    public boolean supports(TestClass testClass) {
        return this.getAnnotatedContextMethods(testClass).length > 0;
    }

    public RemoteTestScopeApplicationContext createApplicationContext(TestClass testClass) {
        Method[] customContextMethods = this.getAnnotatedContextMethods(testClass);
        if (customContextMethods.length > 1) {
            throw new RuntimeException(String.format("Class %s must declare only one method annotated with SpringContextConfiguration.", testClass.getName()));
        }
        ApplicationContext applicationContext = this.getCustomApplicationContext(customContextMethods[0]);
        if (applicationContext == null) {
            throw new RuntimeException(String.format("The method %s returned null as a application context.", customContextMethods[0].getName()));
        }
        return new RemoteTestScopeApplicationContext(applicationContext, testClass, true);
    }

    private ApplicationContext getCustomApplicationContext(Method customContextMethod) {
        try {
            return (ApplicationContext)customContextMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("An error occurred when invoking custom context method.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An error occurred when invoking custom context method.", e);
        }
    }

    private Method[] getAnnotatedContextMethods(TestClass testClass) {
        return SecurityActions.getStaticMethodsWithAnnotation((Class)testClass.getJavaClass(), SpringContextConfiguration.class);
    }
}

