/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.container;

import java.text.MessageFormat;
import javax.servlet.ServletContext;
import org.jboss.arquillian.spring.integration.context.AbstractApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.RemoteTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.test.annotation.SpringWebConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class WebApplicationContextProducer
extends AbstractApplicationContextProducer {
    public boolean supports(TestClass testClass) {
        return testClass.isAnnotationPresent(SpringWebConfiguration.class);
    }

    public RemoteTestScopeApplicationContext createApplicationContext(TestClass testClass) {
        return new RemoteTestScopeApplicationContext(this.getWebApplicationContext(testClass), testClass, false);
    }

    private ApplicationContext getWebApplicationContext(TestClass testClass) {
        WebApplicationContext applicationContext;
        WebApplicationContext rootContext = ContextLoader.getCurrentWebApplicationContext();
        if (rootContext == null) {
            throw new RuntimeException("The Spring Root Web Application Context could not be found.");
        }
        SpringWebConfiguration springWebConfiguration = (SpringWebConfiguration)testClass.getAnnotation(SpringWebConfiguration.class);
        if (!WebApplicationContextProducer.isEmpty(springWebConfiguration.servletName())) {
            applicationContext = this.getServletApplicationContext(rootContext, springWebConfiguration.servletName());
            if (applicationContext == null) {
                throw new RuntimeException("Could not find the application context for servlet: " + springWebConfiguration.servletName());
            }
        } else {
            applicationContext = rootContext;
        }
        return applicationContext;
    }

    private ApplicationContext getServletApplicationContext(WebApplicationContext rootContext, String servletName) {
        ServletContext servletContext = rootContext.getServletContext();
        return (ApplicationContext)servletContext.getAttribute(MessageFormat.format("org.springframework.web.servlet.FrameworkServlet.CONTEXT.{0}", servletName));
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

