/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.InitialContext;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.testenricher.cdi.MethodParameterInjectionPoint;
import org.jboss.arquillian.testenricher.cdi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIInjectionEnricher
implements TestEnricher {
    private static final String STANDARD_BEAN_MANAGER_JNDI_NAME = "java:comp/BeanManager";
    private static final String SERVLET_BEAN_MANAGER_JNDI_NAME = "java:comp/env/BeanManager";
    private static final String JBOSSAS_BEAN_MANAGER_JNDI_NAME = "java:global/test/arquillian-protocol/BeanManager";
    private static final String ANNOTATION_NAME = "javax.inject.Inject";
    private static final Logger log = Logger.getLogger(CDIInjectionEnricher.class.getName());

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            BeanManager beanManager = this.lookupBeanManager();
            if (beanManager == null) {
                return values;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                values[i] = this.getInstanceByType(beanManager, i, method);
            }
        }
        return values;
    }

    private <T> T getInstanceByType(BeanManager manager, int position, Method method) {
        CreationalContext cc = manager.createCreationalContext(null);
        return (T)manager.getInjectableReference(new MethodParameterInjectionPoint(method, position, manager), cc);
    }

    protected void injectClass(Object testCase) {
        try {
            BeanManager beanManager = this.lookupBeanManager();
            if (beanManager != null) {
                this.injectNonContextualInstance(beanManager, testCase);
            } else {
                log.info("BeanManager cannot be located at java:comp/BeanManager. Either you are using an archive with no beans.xml, or the BeanManager has not been bound to that location in JNDI.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    protected void injectNonContextualInstance(BeanManager manager, Object instance) {
        CreationalContext creationalContext = manager.createCreationalContext(null);
        InjectionTarget injectionTarget = manager.createInjectionTarget(manager.createAnnotatedType(instance.getClass()));
        injectionTarget.inject(instance, creationalContext);
    }

    protected BeanManager lookupBeanManager() {
        try {
            return (BeanManager)new InitialContext().lookup(STANDARD_BEAN_MANAGER_JNDI_NAME);
        }
        catch (Exception e) {
            try {
                return (BeanManager)new InitialContext().lookup(SERVLET_BEAN_MANAGER_JNDI_NAME);
            }
            catch (Exception se) {
                try {
                    return (BeanManager)new InitialContext().lookup(JBOSSAS_BEAN_MANAGER_JNDI_NAME);
                }
                catch (Exception je) {
                    return null;
                }
            }
        }
    }
}

