/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedPreparedStatement;

public abstract class WrappedCallableStatement
extends WrappedPreparedStatement
implements CallableStatement {
    private final CallableStatement cs;

    public WrappedCallableStatement(WrappedConnection lc, CallableStatement cs, boolean spy, String jndiName) {
        super(lc, cs, spy, jndiName);
        this.cs = cs;
    }

    @Override
    public CallableStatement getUnderlyingStatement() throws SQLException {
        return (CallableStatement)super.getUnderlyingStatement();
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getObject(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> typeMap) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, typeMap});
            }
            return this.cs.getObject(parameterIndex, typeMap);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getObject(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> typeMap) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, typeMap});
            }
            return this.cs.getObject(parameterName, typeMap);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getBoolean(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getBoolean(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getByte(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getByte(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getShort(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getShort(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getInt(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getInt(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getLong(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getLong(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getFloat(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getFloat(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getDouble(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getDouble(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getBytes(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getBytes(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getURL(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getURL(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getString(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getString(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getRef(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getRef(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getTime(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, calendar});
            }
            return this.cs.getTime(parameterIndex, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getTime(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, calendar});
            }
            return this.cs.getTime(parameterName, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getDate(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, calendar});
            }
            return this.cs.getDate(parameterIndex, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getDate(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, calendar});
            }
            return this.cs.getDate(parameterName, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] registerOutParameter(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, sqlType});
            }
            this.cs.registerOutParameter(parameterIndex, sqlType);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, sqlType, scale});
            }
            this.cs.registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, sqlType, typeName});
            }
            this.cs.registerOutParameter(parameterIndex, sqlType, typeName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] registerOutParameter(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, sqlType});
            }
            this.cs.registerOutParameter(parameterName, sqlType);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, sqlType, scale});
            }
            this.cs.registerOutParameter(parameterName, sqlType, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, sqlType, typeName});
            }
            this.cs.registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] wasNull()", (Object)this.jndiName, (Object)"CallableStatement");
            }
            return this.cs.wasNull();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBigDecimal(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, scale});
            }
            return this.cs.getBigDecimal(parameterIndex, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getBigDecimal(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getBigDecimal(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getTimestamp(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, calendar});
            }
            return this.cs.getTimestamp(parameterIndex, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getTimestamp(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, calendar});
            }
            return this.cs.getTimestamp(parameterName, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getBlob(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getBlob(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getClob(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getClob(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return this.cs.getArray(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return this.cs.getArray(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            CallableStatement wrapped;
            if (this.spy) {
                spyLogger.debugf("%s [%s] isClosed()", (Object)this.jndiName, (Object)"CallableStatement");
            }
            if ((wrapped = this.getWrappedObject()) == null) {
                return true;
            }
            return wrapped.isClosed();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] isPoolable()", (Object)this.jndiName, (Object)"CallableStatement");
            }
            return statement.isPoolable();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setPoolable(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)poolable);
            }
            statement.setPoolable(poolable);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBoolean(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setBoolean(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setByte(String parameterName, byte value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setByte(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setByte(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setShort(String parameterName, short value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setShort(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setShort(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setInt(String parameterName, int value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setInt(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setInt(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setLong(String parameterName, long value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setLong(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setLong(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFloat(String parameterName, float value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setFloat(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, Float.valueOf(value)});
            }
            this.cs.setFloat(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setDouble(String parameterName, double value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setDouble(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setDouble(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setURL(String parameterName, URL value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setURL(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setURL(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTime(String parameterName, Time value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setTime(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setTime(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTime(String parameterName, Time value, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setTime(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value, calendar});
            }
            this.cs.setTime(parameterName, value, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNull(String parameterName, int value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNull(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setNull(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNull(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, sqlType, typeName});
            }
            this.cs.setNull(parameterName, sqlType, typeName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBigDecimal(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setBigDecimal(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setString(String parameterName, String value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setString(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setString(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBytes(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, Arrays.toString(value)});
            }
            this.cs.setBytes(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setDate(String parameterName, Date value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setDate(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setDate(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setDate(String parameterName, Date value, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setDate(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value, calendar});
            }
            this.cs.setDate(parameterName, value, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setTimestamp(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setTimestamp(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp value, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setTimestamp(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value, calendar});
            }
            this.cs.setTimestamp(parameterName, value, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream stream, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, stream, length});
            }
            this.cs.setAsciiStream(parameterName, stream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream stream, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, stream, length});
            }
            this.cs.setBinaryStream(parameterName, stream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setObject(String parameterName, Object value, int sqlType, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setObject(%s, %s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value, sqlType, scale});
            }
            this.cs.setObject(parameterName, value, sqlType, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setObject(String parameterName, Object value, int sqlType) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setObject(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value, sqlType});
            }
            this.cs.setObject(parameterName, value, sqlType);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setObject(String parameterName, Object value) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setObject(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            this.cs.setObject(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, reader, length});
            }
            this.cs.setCharacterStream(parameterName, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, x, length});
            }
            statement.setAsciiStream(parameterIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setAsciiStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, x});
            }
            statement.setAsciiStream(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, x, length});
            }
            statement.setBinaryStream(parameterIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBinaryStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, x});
            }
            statement.setBinaryStream(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBlob(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, inputStream, length});
            }
            statement.setBlob(parameterIndex, inputStream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBlob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, inputStream});
            }
            statement.setBlob(parameterIndex, inputStream);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, reader, length});
            }
            statement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setCharacterStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, reader});
            }
            statement.setCharacterStream(parameterIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setClob(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, reader, length});
            }
            statement.setClob(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setClob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, reader});
            }
            statement.setClob(parameterIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, value, length});
            }
            statement.setNCharacterStream(parameterIndex, value, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, value});
            }
            statement.setNCharacterStream(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, value});
            }
            statement.setNClob(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNClob(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, reader, length});
            }
            statement.setNClob(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, reader});
            }
            statement.setNClob(parameterIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNString(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, value});
            }
            statement.setNString(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setRowId(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, x});
            }
            statement.setRowId(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setSQLXML(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterIndex, xmlObject});
            }
            statement.setSQLXML(parameterIndex, xmlObject);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return statement.getCharacterStream(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return statement.getCharacterStream(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return statement.getNCharacterStream(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return statement.getCharacterStream(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return statement.getNClob(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return statement.getNClob(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return statement.getNString(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return statement.getNString(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return statement.getRowId(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return statement.getRowId(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterIndex);
            }
            return statement.getSQLXML(parameterIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)"CallableStatement", (Object)parameterName);
            }
            return statement.getSQLXML(parameterName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, x, length});
            }
            statement.setAsciiStream(parameterName, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setAsciiStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, x});
            }
            statement.setAsciiStream(parameterName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, x, length});
            }
            statement.setBinaryStream(parameterName, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBinaryStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, x});
            }
            statement.setBinaryStream(parameterName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBlob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, x});
            }
            statement.setBlob(parameterName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBlob(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, inputStream, length});
            }
            statement.setBlob(parameterName, inputStream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setBlob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, inputStream});
            }
            statement.setBlob(parameterName, inputStream);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, reader, length});
            }
            statement.setCharacterStream(parameterName, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setCharacterStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, reader});
            }
            statement.setCharacterStream(parameterName, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setClob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, x});
            }
            statement.setClob(parameterName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setClob(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, reader, length});
            }
            statement.setClob(parameterName, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setClob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, reader});
            }
            statement.setClob(parameterName, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value, length});
            }
            statement.setNCharacterStream(parameterName, value, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            statement.setNCharacterStream(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            statement.setNClob(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNClob(%s, %s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, reader, length});
            }
            statement.setNClob(parameterName, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, reader});
            }
            statement.setNClob(parameterName, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setNString(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, value});
            }
            statement.setNString(parameterName, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setRowId(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, x});
            }
            statement.setRowId(parameterName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        CallableStatement statement = this.getUnderlyingStatement();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setSQLXML(%s, %s)", new Object[]{this.jndiName, "CallableStatement", parameterName, xmlObject});
            }
            statement.setSQLXML(parameterName, xmlObject);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    protected CallableStatement getWrappedObject() throws SQLException {
        return (CallableStatement)super.getWrappedObject();
    }
}

