/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.oracle;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.extensions.oracle.SecurityActions;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.logging.Logger;

public class OracleValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 1937054230333286884L;
    private static Logger log = Logger.getLogger(OracleValidConnectionChecker.class);

    @Override
    public SQLException isValidConnection(Connection c) {
        try {
            Method ping = c.getClass().getMethod("pingDatabase", null);
            SecurityActions.setAccessible(ping);
            Integer status = (Integer)ping.invoke((Object)c, (Object[])null);
            if (status == null || status < 0) {
                return new SQLException("pingDatabase failed status=" + status);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected error in pingDatabase", (Throwable)e);
        }
        return null;
    }
}

