/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.local;

import java.util.Collections;
import java.util.List;
import org.jboss.jca.adapters.jdbc.spi.URLSelectorStrategy;

public class URLSelector
implements URLSelectorStrategy {
    private List<String> urls;
    private String currentUrl;
    private int currentIndex;

    @Override
    public void init(List<String> urls) {
        if (urls == null || urls.size() == 0) {
            throw new IllegalArgumentException("Urls is empty");
        }
        this.urls = Collections.unmodifiableList(urls);
        this.reset();
    }

    @Override
    public boolean hasMore() {
        return this.currentIndex < this.urls.size() - 1;
    }

    @Override
    public String active() {
        if (this.currentUrl != null) {
            return this.currentUrl;
        }
        ++this.currentIndex;
        if (this.currentIndex == this.urls.size()) {
            this.currentIndex = 0;
        }
        this.currentUrl = this.urls.get(this.currentIndex);
        return this.currentUrl;
    }

    @Override
    public void fail(String url) {
        if (this.currentUrl != null && this.currentUrl.equals(url)) {
            this.currentUrl = null;
        }
    }

    @Override
    public void reset() {
        this.currentUrl = null;
        this.currentIndex = -1;
    }

    @Override
    public String getData() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.urls.size(); ++i) {
            String url = this.urls.get(i);
            sb.append(url);
            if (i >= this.urls.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("URLSelector@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[urls=").append(this.urls);
        sb.append(" currentUrl=").append(this.currentUrl);
        sb.append(" currentIndex=").append(this.currentIndex);
        sb.append("]");
        return sb.toString();
    }
}

