/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextListener;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.XidTransactionID;

class RecoveryOnlySerializedEJBXAResource
implements XAResource,
Serializable {
    private static final long serialVersionUID = -8675861321388933320L;
    private final String ejbReceiverNodeName;

    RecoveryOnlySerializedEJBXAResource(String ejbReceiverNodeName) {
        this.ejbReceiverNodeName = ejbReceiverNodeName;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        EJBClientContext context;
        List receiverContexts = ReceiverRegistrationListener.INSTANCE.getRelevantReceiverContexts(this.ejbReceiverNodeName);
        if (receiverContexts.isEmpty() && ((context = EJBClientContext.getCurrent()) == null || context.getNodeEJBReceiver(this.ejbReceiverNodeName) == null || receiverContexts.isEmpty())) {
            Logs.TXN.debugf("No EJB receiver contexts available for committing EJB XA resource for Xid %s during transaction recovery. Returning XAException.XA_RETRY", xid);
            throw new XAException(4);
        }
        XidTransactionID transactionID = new XidTransactionID(xid);
        for (EJBReceiverContext receiverContext : receiverContexts) {
            EJBReceiver receiver = receiverContext.getReceiver();
            Logs.TXN.debugf("%s sending commit request for Xid %s to EJB receiver with node name %s during recovery. One phase? %s", new Object[]{this, xid, receiver.getNodeName(), onePhase});
            receiver.sendCommit(receiverContext, transactionID, onePhase);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        EJBClientContext context;
        List receiverContexts = ReceiverRegistrationListener.INSTANCE.getRelevantReceiverContexts(this.ejbReceiverNodeName);
        if (receiverContexts.isEmpty() && ((context = EJBClientContext.getCurrent()) == null || context.getNodeEJBReceiver(this.ejbReceiverNodeName) == null || receiverContexts.isEmpty())) {
            Logs.TXN.debugf("No EJB receiver contexts available for rolling back EJB XA resource for Xid %s during transaction recovery. Returning XAException.XA_RETRY", xid);
            throw new XAException(4);
        }
        XidTransactionID transactionID = new XidTransactionID(xid);
        for (EJBReceiverContext receiverContext : receiverContexts) {
            EJBReceiver receiver = receiverContext.getReceiver();
            Logs.TXN.debugf("%s sending rollback request for Xid %s to EJB receiver with node name %s during recovery", this, xid, receiver.getNodeName());
            receiver.sendRollback(receiverContext, transactionID);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        EJBClientContext context;
        List receiverContexts = ReceiverRegistrationListener.INSTANCE.getRelevantReceiverContexts(this.ejbReceiverNodeName);
        if (receiverContexts.isEmpty() && ((context = EJBClientContext.getCurrent()) == null || context.getNodeEJBReceiver(this.ejbReceiverNodeName) == null || receiverContexts.isEmpty())) {
            Logs.TXN.debugf("No EJB receiver contexts available for forgetting EJB XA resource for Xid %s during transaction recovery. Returning XAException.XA_RETRY", xid);
            throw new XAException(4);
        }
        XidTransactionID transactionID = new XidTransactionID(xid);
        for (EJBReceiverContext receiverContext : receiverContexts) {
            EJBReceiver receiver = receiverContext.getReceiver();
            Logs.TXN.debugf("%s sending forget request for Xid %s to EJB receiver with node name %s during recovery", this, xid, receiver.getNodeName());
            receiver.sendForget(receiverContext, transactionID);
        }
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        Logs.TXN.debugf("Ignoring end request on XAResource %s since this XAResource is only meant for transaction recovery", this);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (Logs.TXN.isDebugEnabled()) {
            Logs.TXN.debug("Prepare wasn't supposed to be called on " + this + " since this XAResource is only meant for transaction recovery. Ignoring the prepare request for xid " + xid);
        }
        return 0;
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        return new Xid[0];
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        Logs.TXN.debugf("Ignoring start request on XAResource %s since this XAResource is only meant for transaction recovery", this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RecoveryOnlySerializedEJBXAResource");
        sb.append("{ejbReceiverNodeName='").append(this.ejbReceiverNodeName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    static class ReceiverRegistrationListener
    implements EJBClientContextListener {
        static final ReceiverRegistrationListener INSTANCE = new ReceiverRegistrationListener();
        private final List<EJBReceiverContext> relevantReceiverContexts = Collections.synchronizedList(new ArrayList());

        private ReceiverRegistrationListener() {
        }

        @Override
        public void contextClosed(EJBClientContext ejbClientContext) {
        }

        @Override
        public void receiverRegistered(EJBReceiverContext receiverContext) {
            this.relevantReceiverContexts.add(receiverContext);
        }

        @Override
        public void receiverUnRegistered(EJBReceiverContext receiverContext) {
            this.relevantReceiverContexts.remove(receiverContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<EJBReceiverContext> getRelevantReceiverContexts(String nodeName) {
            ArrayList<EJBReceiverContext> eligibleReceiverContext = new ArrayList<EJBReceiverContext>();
            List<EJBReceiverContext> list = this.relevantReceiverContexts;
            synchronized (list) {
                for (EJBReceiverContext receiverContext : this.relevantReceiverContexts) {
                    if (receiverContext == null) continue;
                    if (nodeName == null) {
                        eligibleReceiverContext.add(receiverContext);
                        continue;
                    }
                    if (!nodeName.equals(receiverContext.getReceiver().getNodeName())) continue;
                    eligibleReceiverContext.add(receiverContext);
                }
            }
            return eligibleReceiverContext;
        }
    }
}

