/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionManager;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;

abstract class MaxAttemptsReconnectHandler
implements ReconnectHandler {
    private static final Logger logger = Logger.getLogger(MaxAttemptsReconnectHandler.class);
    protected final Endpoint endpoint;
    protected final String protocol;
    protected final String host;
    protected final int port;
    protected final EJBClientConfiguration.CommonConnectionCreationConfiguration connectionConfiguration;
    protected final int maxReconnectAttempts;
    private final RemotingConnectionManager remotingConnectionManager = new RemotingConnectionManager();
    protected volatile int reconnectAttempts;

    MaxAttemptsReconnectHandler(Endpoint endpoint, String protocol, String host, int port, EJBClientConfiguration.CommonConnectionCreationConfiguration connectionConfiguration, int maxReconnectAttempts) {
        this.endpoint = endpoint;
        this.connectionConfiguration = connectionConfiguration;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    protected Connection tryConnect() {
        if (this.reconnectAttempts >= this.maxReconnectAttempts) {
            return null;
        }
        ++this.reconnectAttempts;
        try {
            Connection connection = this.remotingConnectionManager.getConnection(this.endpoint, this.protocol, this.host, this.port, this.connectionConfiguration);
            logger.debugf("Successfully reconnected on attempt#%d to connection %s", this.reconnectAttempts, (Object)connection);
            return connection;
        }
        catch (Exception e) {
            logger.debugf((Throwable)e, "Re-connect attempt# %d failed for %s:%d", (Object)this.reconnectAttempts, (Object)this.host, (Object)this.port);
            return null;
        }
    }

    protected boolean hasMoreAttempts() {
        return this.reconnectAttempts < this.maxReconnectAttempts;
    }
}

