/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Unmarshaller;

class TransactionRecoveryResponseHandler
extends ProtocolMessageHandler {
    private final ChannelAssociation channelAssociation;
    private final MarshallerFactory marshallerFactory;

    TransactionRecoveryResponseHandler(ChannelAssociation channelAssociation, MarshallerFactory marshallerFactory) {
        this.channelAssociation = channelAssociation;
        this.marshallerFactory = marshallerFactory;
    }

    @Override
    protected void processMessage(InputStream inputStream) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            short invocationId = dataInputStream.readShort();
            int numXidsToRecover = PackedInteger.readPackedInteger(dataInputStream);
            if (numXidsToRecover > 0) {
                Unmarshaller unmarshaller = this.prepareForUnMarshalling(this.marshallerFactory, dataInputStream);
                Xid[] xidsToRecover = new Xid[numXidsToRecover];
                for (int i = 0; i < numXidsToRecover; ++i) {
                    XidTransactionID xidTransactionID = (XidTransactionID)unmarshaller.readObject();
                    xidsToRecover[i] = xidTransactionID.getXid();
                }
                unmarshaller.finish();
                this.channelAssociation.resultReady(invocationId, new TxRecoveryResultProducer(xidsToRecover));
            } else {
                this.channelAssociation.resultReady(invocationId, new TxRecoveryResultProducer(new Xid[0]));
            }
        }
    }

    private class TxRecoveryResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private Xid[] xidsToRecover;

        TxRecoveryResultProducer(Xid[] xidsToRecover) {
            this.xidsToRecover = xidsToRecover;
        }

        @Override
        public Object getResult() throws Exception {
            return this.xidsToRecover;
        }

        @Override
        public void discardResult() {
        }
    }
}

