/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ant.taskdefs.server;

import java.io.IOException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.Project;
import org.jboss.test.util.server.ServerManager;
import org.jboss.test.util.server.ServerShutdownException;

/**
 * A StopServerTask.
 * 
 * @author <a href="ryan.campbell@jboss.com">Ryan Campbell</a>
 * @version $Revision: 68539 $
 */
public class StopServerTask extends Task
{

   private String name;

   private boolean failonerror = false;

   /**
    * Stop the server.
    */

   public void execute() throws BuildException
   {
      ServerManager manager = (ServerManager) getProject().getReference(ConfigManagerTask.MANAGER_REF);
      if ( manager == null ) throw new BuildException("Can't find reference to server manager. Consider context you execute server tasks.");
      try
      {
         manager.stopServer(name);
      }
      catch (IOException e)
      {
			if (e instanceof ServerShutdownException && !failonerror)
			{
				log("Unable to shutdown server properly: " + e, Project.MSG_ERR);
			}
			else
			{
				throw new BuildException("Error stopping server \"" + name + "\": " + e.toString(), e);
			}
      }
   }

   /**
    * Set the name.
    * 
    * @param name The name to set.
    */
   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * Set failonerror.
    * 
    * @param failonerror Choice to set.
    */
   public void setFailOnError(boolean flag)
   {
      this.failonerror = flag;
   }
}