/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.test;

import java.util.StringTokenizer;

import junit.framework.Test;

/**
 * Derived implementation of JBossTestSetup for cluster testing.
 *
 * @see org.jboss.test.JBossTestSetup
 *
 * @author  <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @version $Revision: 68538 $
 *
 * <p><b>Revisions:</b>
 *
 * <p><b>12 avril 2002 Sacha Labourey:</b>
 * <ul>
 * <li> First implementation </li>
 * </ul>
 */

public class JBossTestClusteredSetup extends JBossTestSetup
{
   
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   private String jarNames;
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   public JBossTestClusteredSetup(Test test, String jarNames) throws Exception
   {
      super(JBossClusteredTestCase.class, test);
      this.jarNames = jarNames;
   }
   
   
   // Public --------------------------------------------------------
   
   // Z implementation ----------------------------------------------
   
   // Y overrides ---------------------------------------------------
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   protected JBossTestServices createTestServices()
   {
      return new JBossTestClusteredServices(getClass());
   }
   
   protected void setUp() throws Exception
   {      
      super.setUp();
      
      if (jarNames == null) return;
      JBossTestCase.deploymentException = null;
      try
      {
         // deploy the comma seperated list of jars
         StringTokenizer st = new StringTokenizer(jarNames, ", ");
         while (st.hasMoreTokens())
         {
            String jarName = st.nextToken();
            this.redeploy(jarName);
            this.getLog().debug("deployed package: " + jarName);
         }
      }
      catch (Exception ex)
      {
         // Throw this in testServerFound() instead.
         JBossTestCase.deploymentException = ex;
      }
          
      // wait a few seconds so that the cluster stabilize
      synchronized (this)
      {
         wait(2000);
      }
   }

   protected void tearDown() throws Exception
   {
      try
      {
         if (jarNames != null)
         {
            // deploy the comma seperated list of jars
            StringTokenizer st = new StringTokenizer(jarNames, ", ");
            String[] depoyments = new String[st.countTokens()];
            for (int i = depoyments.length - 1; i >= 0; i--)
               depoyments[i] = st.nextToken();
            for (int i = 0; i < depoyments.length; i++)
            {
               String jarName = depoyments[i];
               this.getLog().debug("Attempt undeploy of " + jarName);
               this.undeploy(jarName);
               this.getLog().debug("undeployed package: " + jarName);
            }            
         }
         super.tearDown();
      }
      finally
      {
         AbstractTestSetup.delegate = null;
      }
     
   }
   

   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
   
}
