package org.jboss.profileservice.management;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

import org.jboss.managed.api.ManagedProperty;

public class BaseManagedObject
   implements Serializable
{
   private static final long serialVersionUID = 1;
   private String simpleName;
   private Map<String, ManagedProperty> properties;

   public BaseManagedObject(String simpleName, Map<String, ManagedProperty> properties)
   {
      this.simpleName = simpleName;
      this.properties = properties;
   }

   public String getSimpleName()
   {
      return simpleName;
   }
   public String getName()
   {
      return simpleName;
   }

   /**
    * Get the managed property names
    * 
    * @return the property names
    */
   public Set<String> getPropertyNames()
   {
      return properties.keySet();
   }

   /**
    * Get a property
    * 
    * @param name the name
    * @return the property
    */
   public ManagedProperty getProperty(String name)
   {
      ManagedProperty prop = properties.get(name);
      return prop;
   }
   
   /**
    * Get the properties
    * 
    * @return the properties
    */
   public Map<String, ManagedProperty> getProperties()
   {
      return properties;
   }

   /**
    * Append the name and props 
    * @param sb the buffer to append the name and props to
    */
   protected void toString(StringBuilder sb)
   {
      sb.append("simpleName=");
      sb.append(simpleName);
      sb.append(", properties=");
      sb.append(properties);
   }
}
