/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.management.builders;

import java.io.Serializable;

import org.jboss.managed.api.Fields;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;

/**
 * A Fields implementation that maps to a service attribute.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class ServiceAttributeFields extends DefaultFieldsImpl
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 1L;

   /** The datasource element */
   private ServiceAttributeMetaData metaData; 
   
   /**
    * Create a new ServiceAttributeFields.
    *
    * @param metaData the service attribute metadata the field maps to.
    */
   public ServiceAttributeFields(ServiceAttributeMetaData metaData)
   {
      this(metaData, metaData.getName(), null);
   }
   /**
    * Create a new ServiceAttributeFields with the given field name;
    *
    * @param metaData the service attribute metadata the field maps to.
    * @param fieldName the field name to use. If its null the attribute
    * name will be used.
    */   
   public ServiceAttributeFields(ServiceAttributeMetaData metaData, String fieldName,
         String mappedName)
   {
      this.metaData = metaData;
      if( fieldName == null )
         fieldName = metaData.getName();
      this.setField(Fields.NAME, fieldName);
      if( mappedName != null )
         this.setField(Fields.MAPPED_NAME, mappedName);
   }

   public Serializable getField(String name)
   {
      if (VALUE.equals(name))
      {
         ServiceTextValueMetaData text = (ServiceTextValueMetaData) metaData.getValue();
         return text.getText();
      }
      return super.getField(name);
   }

   public void setField(String name, Serializable value)
   {
      if (VALUE.equals(name))
      {
         String string = value.toString();
         ServiceTextValueMetaData text = new ServiceTextValueMetaData(string);
         this.metaData.setValue(text);
         return;
      }
      super.setField(name, value);
   }
}
