/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.management.templates;

import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;

import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.mock.ds.DataSourceDeployment;
import org.jboss.profileservice.mock.ds.FakeDataSourceDeployer;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.virtual.VirtualFile;

/**
 * A template for creating a datasource(*-dsf.xml) deployments.
 * 
 * @author Scott.Stark@jboss.org
 * @author adrian@jboss.org
 * @version $Revision:$
 */
public class FakeDsXmlDataSourceTemplate
   implements DeploymentTemplate
{
   /**
    * The managed property information
    */
   private DeploymentTemplateInfo info;
   /**
    * The deployer used to 
    */
   private FakeDataSourceDeployer deployer;
   private Map<String, String> propertyNameMappings;

   public Map<String, String> getPropertyNameMappings()
   {
      return propertyNameMappings;
   }

   public void setPropertyNameMappings(Map<String, String> propertyNameMappings)
   {
      this.propertyNameMappings = propertyNameMappings;
   }

   public FakeDataSourceDeployer getDeployer()
   {
      return deployer;
   }

   public void setDeployer(FakeDataSourceDeployer deployer)
   {
      this.deployer = deployer;
   }

   /**
    * Creates a root/{deploymentBaseName}-dsf.xml base descriptor
    * with minimal fields containing default values.
    */
   public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName,
         DeploymentTemplateInfo values)
      throws Exception
   {
      String dsName = deploymentBaseName+"-dsf.xml";
      URI dsXmlURI = new URI(root.toURI()+dsName);
      File dsXml = new File(dsXmlURI.getPath());
      writeTemplate(dsXml, values);
      return root.findChild(dsName);
   }
   /**
    * Update the ctx with the metadata values that correspond to the
    * template info values.
    * @param ctx - the DeploymentContext to associate metadata to
    * @param values - the managed property values passed to apply.
    */
   public void updateTemplateDeployment(VFSDeployment ctx,
         DeploymentTemplateInfo values)
      throws Exception
   {
      // Add the -dsf.xml metadata
      ServiceDeployment service = new ServiceDeployment();
      ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
      DataSourceDeployment ds = new DataSourceDeployment();
      ds.parse(values.getProperties());
      ServiceMetaData dsMetaData = deployer.createDsServiceMetaData(ds);
      services.add(dsMetaData);
      service.setServices(services);
      /** TODO What is this?
      ctx.getTransientAttachments().addAttachment(ServiceDeployment.class, service);
      */   
   }

   public DeploymentTemplateInfo getInfo()
   {
      return info;
   }
   public void setInfo(DeploymentTemplateInfo info)
   {
      this.info = info;
   }

   protected void writeTemplate(File dsXml, DeploymentTemplateInfo values)
      throws Exception
   {
      FileWriter fw = new FileWriter(dsXml);
      Map<String, ManagedProperty> properties = values.getProperties();
      ManagedProperty type = properties.get("datasource-type");
      String typeTag = "local-tx-datasource";
      if( type != null && type.getValue() != null )
         typeTag = type.getValue().toString();

      /* Write out a minimal template with the datasource type and
         some defaults. All other properties will be applied to the
         attachment metdata. 
       */
      fw.write("<datasources>\n");
      fw.write("<"+typeTag+">\n");
      fw.write("<jndi-name>default</jndi-name>\n");
      fw.write("<connection-url>jdbc:...</connection-url>\n");
      fw.write("<driver-class>default</driver-class>\n");
      fw.write("<user-name>default</user-name>\n");
      fw.write("<password>default</password>\n");
      fw.write("<min-pool-size>1</min-pool-size>\n");
      fw.write("<max-pool-size>10</max-pool-size>\n");
      fw.write("<security-domain>default</security-domain>\n");
      fw.write("</"+typeTag+">\n");
      fw.write("</datasources>\n");
      fw.flush();
      fw.close();
   }
}
