package org.jboss.profileservice.mock.ds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * The deployment metadata used to represent the FakeDataSourceDeployer
 * attachment. This is a javabean form of the *-dsf.xml fields.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 64106 $
 */
public class DataSourceDeployment
   implements Serializable
{
   private static final long serialVersionUID = 1;

   private static Logger log = Logger.getLogger(DataSourceDeployment.class);

   private boolean replace = true;
   private String type;
   private String jndiName;
   private String driverClass;
   private String typeMapping;
   private String jdbcURL;
   private String username;
   private String password;
   private String securityDomain;
   private String minPoolSize;
   private String maxPoolSize;
   private Properties connProps;
   private ArrayList<String> depends = new ArrayList<String>();
   
   public String getType()
   {
      return type;
   }

   public void setType(String type)
   {
      this.type = type;
   }

   public String getDriverClass()
   {
      return driverClass;
   }

   public void setDriverClass(String driverClass)
   {
      this.driverClass = driverClass;
   }

   public String getJdbcURL()
   {
      return jdbcURL;
   }

   public void setJdbcURL(String jdbcURL)
   {
      this.jdbcURL = jdbcURL;
   }

   public String getJndiName()
   {
      return jndiName;
   }

   public void setJndiName(String jndiName)
   {
      this.jndiName = jndiName;
   }

   public String getMaxPoolSize()
   {
      return maxPoolSize;
   }

   public void setMaxPoolSize(String maxPoolSize)
   {
      this.maxPoolSize = maxPoolSize;
   }

   public String getMinPoolSize()
   {
      return minPoolSize;
   }

   public void setMinPoolSize(String minPoolSize)
   {
      this.minPoolSize = minPoolSize;
   }

   public String getPassword()
   {
      return password;
   }

   public void setPassword(String password)
   {
      this.password = password;
   }

   public boolean isReplace()
   {
      return replace;
   }

   public void setReplace(boolean replace)
   {
      this.replace = replace;
   }

   public String getSecurityDomain()
   {
      return securityDomain;
   }

   public void setSecurityDomain(String securityDomain)
   {
      this.securityDomain = securityDomain;
   }

   public String getTypeMapping()
   {
      return typeMapping;
   }

   public void setTypeMapping(String typeMapping)
   {
      this.typeMapping = typeMapping;
   }

   public String getUsername()
   {
      return username;
   }

   public void setUsername(String username)
   {
      this.username = username;
   }

   public Properties getConnectionProperties()
   {
      return connProps;
   }

   public void setConnectionProperties(Properties connProps)
   {
      this.connProps = connProps;
   }

   public List<String> getDepends()
   {
      return depends;
   }

   public void parse(Document document)
   {
      type = "local-tx-datasource";
      NodeList datasources = document.getElementsByTagName(type);
      for (int i = 0; i < datasources.getLength(); ++i)
      {
         Node node = datasources.item(i);
         if (node.getNodeType() == Node.ELEMENT_NODE)
         {
            Element e = (Element) node;
            System.out.println("ELEMENT_NODE: "+e);
            NodeList tags = node.getChildNodes();
            for(int j = 0; j < tags.getLength(); j ++)
            {
               Node child = tags.item(j);
               if(child.getNodeType() == Node.ELEMENT_NODE)
               {
                  Element ej = (Element) child;
                  if (ej.getTagName().equals("jndi-name"))
                  {
                     jndiName = getText(ej);
                  }
                  else if (ej.getTagName().equals("connection-url"))
                  {
                     this.jdbcURL = getText(ej);
                  }
                  else if (ej.getTagName().equals("user-name"))
                  {
                     this.username = getText(ej);
                  }
                  else if (ej.getTagName().equals("driver-class"))
                  {
                     this.driverClass = getText(ej);
                  }
                  else if (ej.getTagName().equals("password"))
                  {
                     this.password = getText(ej);
                     if(this.password == null)
                        this.password = "";
                  }
                  else if (ej.getTagName().equals("min-pool-size"))
                  {
                     this.minPoolSize = getText(ej);
                  }
                  else if (ej.getTagName().equals("max-pool-size"))
                  {
                     this.maxPoolSize = getText(ej);
                  }
                  else if (ej.getTagName().equals("security-domain"))
                  {
                     this.securityDomain = getText(ej);
                  }
                  else if (ej.getTagName().equals("metadata"))
                  {
                     NodeList tms = ej.getElementsByTagName("type-mapping");
                     Element tm = (Element) tms.item(0);
                     this.typeMapping = getText(tm);
                  }
                  else if (ej.getTagName().equals("depends"))
                  {
                     String depends = getText(ej);
                     addDepends(depends);
                  }
                  else if (ej.getTagName().equals("connection-properties"))
                  {
                     // TODO
                     
                  }
               }
            }

         }
      }
   }

   /**
    * Map the managed properties onto this javabean's properties
    * @param propertyNameMappings
    * @param properties
    */
   public void parse(Map<String, ManagedProperty> properties)
   {
      for(ManagedProperty property : properties.values())
      {
         String name = property.getName();
         Object value = property.getValue();
         if( value == null )
            continue;

         if( name.equals("") )
         {
            this.type = value.toString();
         }
         else if (name.equals("jndi-name"))
         {
            jndiName = value.toString();
         }
         else if (name.equals("connection-url"))
         {
            this.jdbcURL = value.toString();
         }
         else if (name.equals("user-name"))
         {
            this.username = value.toString();
         }
         else if (name.equals("driver-class"))
         {
            this.driverClass = value.toString();
         }
         else if (name.equals("password"))
         {
            this.password = value.toString();
            if(this.password == null)
               this.password = "";
         }
         else if (name.equals("min-pool-size"))
         {
            this.minPoolSize = value.toString();
         }
         else if (name.equals("max-pool-size"))
         {
            this.maxPoolSize = value.toString();
         }
         else if (name.equals("security-domain"))
         {
            this.securityDomain = value.toString();
         }
         else if (name.equals("type-mapping"))
         {
            this.typeMapping = value.toString();
         }
         else if (name.equals("connection-properties"))
         {
            CompositeValue cvalue = (CompositeValue) value;
            parseConnProps(cvalue);
         }
         else if (name.equals("depends"))
         {
            String depends = value.toString();
            addDepends(depends);
         }
      }
   }

   @Override
   public String toString()
   {
      StringBuilder tmp = new StringBuilder(super.toString());
      tmp.append('(');
      tmp.append("depends=");
      tmp.append(depends);
      tmp.append(",driverClass=");
      tmp.append(driverClass);
      tmp.append(",jdbcURL=");
      tmp.append(jdbcURL);
      tmp.append(",jndiName=");
      tmp.append(jndiName);
      tmp.append(",username=");
      tmp.append(username);
      tmp.append(",password=");
      tmp.append(password);
      tmp.append(",minPoolSize=");
      tmp.append(minPoolSize);
      tmp.append(",maxPoolSize=");
      tmp.append(maxPoolSize);
      tmp.append(",securityDomain=");
      tmp.append(securityDomain);
      tmp.append(",typeMapping=");
      tmp.append(typeMapping);
      tmp.append(",connProps=");
      tmp.append(connProps);
      tmp.append(')');
      return tmp.toString();
   }

   private void addDepends(String depends)
   {
      this.depends.add(depends);
   }

   private String getText(Node node)
   {
      String text = DOMUtils.getTextContent(node);
      if( text != null && replace )
         text = StringPropertyReplacer.replaceProperties(text);
      return text;
   }
   private void parseConnProps(CompositeValue cvalue)
   {
      connProps = new Properties();
      for(String key : cvalue.getMetaType().keySet())
      {
         if( cvalue.containsKey(key) )
         {
            MetaValue value = cvalue.get(key);
            // We only handle SimpleValue types
            SimpleValue svalue = (SimpleValue) value;
            connProps.setProperty(key, svalue.getValue().toString());
         }
      }
   }

}
