/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.views;

import java.util.Collection;
import java.util.HashMap;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.metadata.spi.MetaData;
import org.jboss.profileservice.management.MBeanManagedObjectFactory;
import org.jboss.profileservice.management.ManagedOperationProxyFactory;
import org.jboss.profileservice.management.views.AbstractProfileView;
import org.jboss.profileservice.spi.ManagedMBeanDeploymentFactory;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;

public class MBeanProfileView
extends AbstractProfileView {
    private static final Logger log = Logger.getLogger(MBeanProfileView.class);
    private static final ProfileKey key = new ProfileKey(MBeanProfileView.class.getName());
    private HashMap<String, ManagedMBeanDeploymentFactory> mdfs = new HashMap();
    private MBeanServer mbeanServer;
    private MBeanManagedObjectFactory mbeanMOFactory = new MBeanManagedObjectFactory();

    public MBeanProfileView(ManagedOperationProxyFactory proxyFactory) {
        super(proxyFactory);
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void addManagedMBeanDeployments(ManagedMBeanDeploymentFactory factory) {
        log.info((Object)("addManagedDeployment, " + factory));
        String name = factory.getFactoryName();
        this.mdfs.put(name, factory);
    }

    public void removeManagedMBeanDeployments(ManagedMBeanDeploymentFactory factory) {
        log.info((Object)("removeManagedDeployment, " + factory));
        String name = factory.getFactoryName();
        this.mdfs.remove(name);
    }

    public ProfileKey getProfileKey() {
        return key;
    }

    protected void load() {
        boolean trace = log.isTraceEnabled();
        for (ManagedMBeanDeploymentFactory mdf : this.mdfs.values()) {
            log.debug((Object)("Processing deployments for factory: " + mdf.getFactoryName()));
            Collection<ManagedMBeanDeploymentFactory.MBeanDeployment> deployments = mdf.getDeployments(this.mbeanServer);
            for (ManagedMBeanDeploymentFactory.MBeanDeployment md : deployments) {
                log.debug((Object)("Saw MBeanDeployment: " + md));
                HashMap<String, ManagedObject> unitMOs = new HashMap<String, ManagedObject>();
                Collection<ManagedMBeanDeploymentFactory.MBeanComponent> components = md.getComponents();
                if (components != null) {
                    for (ManagedMBeanDeploymentFactory.MBeanComponent comp : components) {
                        log.debug((Object)("Saw MBeanComponent: " + comp));
                        try {
                            ManagedObject mo = this.createManagedObject(comp.getName(), mdf.getDefaultViewUse());
                            String annotationExpr = "@org.jboss.managed.api.annotation.ManagementObject(name=\"" + comp.getName() + "\"," + "componentType=@org.jboss.managed.api.annotation.ManagementComponent(type=\"" + comp.getType() + "\",subtype=\"" + comp.getSubtype() + "\")" + ")";
                            ManagementObject moAnn = (ManagementObject)AnnotationCreator.createAnnotation((String)annotationExpr, ManagementObject.class);
                            mo.getAnnotations().put(ManagementObject.class.getName(), moAnn);
                            ManagementComponent mcAnn = moAnn.componentType();
                            mo.getAnnotations().put(ManagementComponent.class.getName(), mcAnn);
                            unitMOs.put(comp.getName().getCanonicalName(), mo);
                        }
                        catch (Exception e) {
                            log.warn((Object)("Failed to create ManagedObject for: " + comp), (Throwable)e);
                        }
                    }
                }
                ManagedDeploymentImpl mdi = new ManagedDeploymentImpl(md.getName(), md.getName(), null, unitMOs);
                try {
                    this.processManagedDeployment((ManagedDeployment)mdi, DeploymentState.STARTED, 0, trace);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to process ManagedDeployment for: " + md.getName()), (Throwable)e);
                }
            }
        }
    }

    private ManagedObject createManagedObject(ObjectName mbean, String defaultViewUse) throws Exception {
        ViewUse[] viewUseArray;
        MBeanInfo info = this.mbeanServer.getMBeanInfo(mbean);
        ClassLoader mbeanLoader = this.mbeanServer.getClassLoaderFor(mbean);
        MetaData metaData = null;
        if (defaultViewUse == null) {
            viewUseArray = null;
        } else {
            ViewUse[] viewUseArray2 = new ViewUse[1];
            viewUseArray = viewUseArray2;
            viewUseArray2[0] = ViewUse.valueOf((String)defaultViewUse);
        }
        ViewUse[] viewUse = viewUseArray;
        ManagedObject mo = this.mbeanMOFactory.getManagedObject(mbean, info, mbeanLoader, metaData, viewUse);
        return mo;
    }

    public boolean hasBeenModified(Profile profile) {
        return false;
    }
}

