/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotatedClassFilter;
import org.jboss.metadata.annotation.creator.client.ApplicationClient5MetaDataCreator;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBoss50Creator;
import org.jboss.metadata.annotation.creator.web.Web30MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.client.spec.ApplicationClient5MetaData;
import org.jboss.metadata.client.spec.ApplicationClientMetaData;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_ANNOTATED_ATTACHMENT_NAME = "annotated." + EjbJarMetaData.class.getName();
    public static final String CLIENT_ANNOTATED_ATTACHMENT_NAME = "annotated." + ApplicationClientMetaData.class.getName();
    public static final String WEB_ANNOTATED_ATTACHMENT_NAME = "annotated." + WebMetaData.class.getName();
    private boolean metaDataCompleteIsDefault = false;

    public AnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(EjbJarMetaData.class);
        this.addInput(WebMetaData.class);
        this.addInput(ApplicationClientMetaData.class);
        this.addOutput(EJB_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(CLIENT_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(WEB_ANNOTATED_ATTACHMENT_NAME);
    }

    public boolean isMetaDataCompleteIsDefault() {
        return this.metaDataCompleteIsDefault;
    }

    public void setMetaDataCompleteIsDefault(boolean metaDataCompleteIsDefault) {
        this.metaDataCompleteIsDefault = metaDataCompleteIsDefault;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit);
    }

    public void undeploy(DeploymentUnit unit) {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.undeploy(vfsDeploymentUnit);
    }

    protected void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        String symbolicName;
        ApplicationClientMetaData clientMetaData;
        boolean isComplete = this.isMetaDataCompleteIsDefault();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        if (ejbJarMetaData != null && ejbJarMetaData instanceof EjbJar3xMetaData) {
            isComplete |= ((EjbJar3xMetaData)ejbJarMetaData).isMetadataComplete();
        } else if (ejbJarMetaData != null) {
            isComplete = true;
        }
        WebMetaData webMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        if (webMetaData != null) {
            isComplete = webMetaData instanceof Web25MetaData ? (isComplete |= ((Web25MetaData)webMetaData).isMetadataComplete()) : (webMetaData instanceof Web30MetaData ? (isComplete |= ((Web30MetaData)webMetaData).isMetadataComplete()) : true);
        }
        if ((clientMetaData = (ApplicationClientMetaData)unit.getAttachment(ApplicationClientMetaData.class)) != null) {
            isComplete |= clientMetaData.isMetadataComplete();
        }
        if (isComplete |= (symbolicName = (String)unit.getAttachment("org.jboss.osgi.bundle.symbolic.name")) != null) {
            this.log.debug((Object)("Deployment is metadata-complete, skipping annotation processing, ejbJarMetaData=" + ejbJarMetaData + ", jbossWebMetaData=" + webMetaData + ", jbossClientMetaData=" + clientMetaData + ", bundleSymbolicName=" + symbolicName + ", metaDataCompleteIsDefault=" + this.metaDataCompleteIsDefault));
            return;
        }
        VirtualFile root = unit.getRoot();
        if (root.isLeaf()) {
            return;
        }
        List classpath = unit.getClassPath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Deploying annotations for unit: " + unit + ", classpath: " + classpath));
        }
        try {
            this.processMetaData(unit, webMetaData, clientMetaData, classpath);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot process metadata", (Throwable)e);
        }
    }

    protected void processMetaData(VFSDeploymentUnit unit, WebMetaData webMetaData, ApplicationClientMetaData clientMetaData, List<VirtualFile> classpath) throws Exception {
        String mainClassName = this.getMainClassName(unit);
        HashSet classes = new HashSet();
        HashMap classesPerJar = new HashMap();
        for (VirtualFile path : classpath) {
            Collection<Class<?>> currentClasses = this.getClasses(unit, mainClassName, path);
            classesPerJar.put(path, currentClasses);
            classes.addAll(currentClasses);
        }
        if (classes.size() > 0) {
            DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
            if (webMetaData != null) {
                this.processJBossWebMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classesPerJar);
            } else if (clientMetaData != null || mainClassName != null) {
                this.processJBossClientMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
            } else {
                this.processJBossMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
            }
        }
    }

    protected Collection<Class<?>> getClasses(VFSDeploymentUnit unit, String mainClassName, VirtualFile classpath) throws IOException {
        AnnotatedClassFilter classVisitor = new AnnotatedClassFilter(unit, unit.getClassLoader(), classpath, mainClassName);
        classpath.visit((VirtualFileVisitor)classVisitor);
        Map<VirtualFile, Class<?>> classes = classVisitor.getAnnotatedClasses();
        if (classes != null && classes.size() > 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Annotated classes: " + classes));
            }
        } else {
            classes = new HashMap();
        }
        return classes.values();
    }

    protected void undeploy(VFSDeploymentUnit unit) {
    }

    protected void processJBossMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        JBoss50Creator creator = new JBoss50Creator(finder);
        JBoss50MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(EJB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, JBossMetaData.class);
        }
    }

    protected void processJBossWebMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Collection<Class<?>>> classes) {
        Web30MetaDataCreator creator = new Web30MetaDataCreator(finder);
        boolean metaData = false;
        for (VirtualFile path : classes.keySet()) {
            Web30MetaData annotationMetaData = creator.create(classes.get(path));
            this.log.debug((Object)("Add annotations: " + WEB_ANNOTATED_ATTACHMENT_NAME + ":" + path.getName()));
            if (annotationMetaData == null) continue;
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME + ":" + path.getName(), (Object)annotationMetaData, WebMetaData.class);
            metaData = true;
        }
        if (metaData) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, (Object)Boolean.TRUE);
        }
    }

    protected void processJBossClientMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        ApplicationClient5MetaDataCreator creator = new ApplicationClient5MetaDataCreator(finder);
        ApplicationClient5MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(CLIENT_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, ApplicationClientMetaData.class);
        }
    }

    protected String getMainClassName(VFSDeploymentUnit unit) throws IOException {
        VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("parsing " + file));
        }
        if (file == null) {
            return null;
        }
        Manifest mf = VFSUtils.readManifest((VirtualFile)file);
        Attributes attrs = mf.getMainAttributes();
        return attrs.getValue(Attributes.Name.MAIN_CLASS);
    }
}

