/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.keygenerator.hilo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.keygenerator.KeyGenerator;
import org.jboss.logging.Logger;

public class HiLoKeyGenerator
implements KeyGenerator {
    private static long highestHi = 0L;
    private final Logger log;
    private final DataSource ds;
    private final long blockSize;
    private long hi;
    private long lo;
    private TransactionManager tm;
    private String updateHiSql;
    private String selectHiSql;

    public static synchronized long getHighestHi() {
        return highestHi;
    }

    public static synchronized void setHighestHi(long highestHi) {
        HiLoKeyGenerator.highestHi = highestHi;
    }

    public HiLoKeyGenerator(DataSource ds, String tableName, String sequenceColumn, String sequenceName, String idColumnName, String selectHiSql, long blockSize, TransactionManager tm) {
        this.ds = ds;
        this.blockSize = blockSize;
        this.tm = tm;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "#" + tableName + "_" + sequenceName));
        this.updateHiSql = "update " + tableName + " set " + idColumnName + "=?" + " where " + sequenceColumn + "='" + sequenceName + "' and " + idColumnName + "=?";
        this.selectHiSql = selectHiSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object generateKey() {
        if (this.lo < this.hi) {
            ++this.lo;
        } else {
            Transaction curTx = null;
            try {
                curTx = this.tm.suspend();
            }
            catch (SystemException e) {
                throw new IllegalStateException("Failed to suspend current transaction.");
            }
            try {
                this.tm.begin();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to begin a new transaction.");
            }
            try {
                this.doGenerate();
                this.tm.commit();
            }
            catch (SQLException e) {
                this.log.error((Object)("Failed to update table: " + e.getMessage()), (Throwable)e);
                try {
                    this.tm.rollback();
                }
                catch (SystemException e1) {
                    this.log.error((Object)"Failed to rollback.", (Throwable)e1);
                }
                throw new IllegalStateException(e.getMessage());
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to commit.", (Throwable)e);
            }
            finally {
                if (curTx != null) {
                    try {
                        this.tm.resume(curTx);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to resume transaction: " + e.getMessage());
                    }
                }
            }
        }
        return new Long(this.lo);
    }

    private void doGenerate() throws SQLException {
        long curHi;
        do {
            curHi = this.getCurrentHi();
            this.lo = curHi + 1L;
            this.hi = curHi + this.blockSize;
        } while (!this.updateHi(curHi, this.hi));
    }

    private long getCurrentHi() throws SQLException {
        return this.selectHiSql != null ? this.selectHi() : HiLoKeyGenerator.getHighestHi();
    }

    private boolean updateHi(long curHi, long newHi) throws SQLException {
        if (this.selectHiSql == null) {
            HiLoKeyGenerator.setHighestHi(newHi);
        }
        return this.updateTable(curHi, newHi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long selectHi() throws SQLException {
        long l;
        Connection con = null;
        PreparedStatement selectHiSt = null;
        ResultSet rs = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Executing SQL: " + this.selectHiSql));
        }
        try {
            con = this.ds.getConnection();
            selectHiSt = con.prepareStatement(this.selectHiSql);
            rs = selectHiSt.executeQuery();
            if (!rs.next()) {
                throw new IllegalStateException("The sequence has not been initialized in the service start phase!");
            }
            l = rs.getLong(1);
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(selectHiSt);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(selectHiSt);
        JDBCUtil.safeClose(con);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTable(long curHi, long newHi) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement updateHi = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Executing SQL: " + this.updateHiSql + ", [" + newHi + "," + curHi + "]"));
        }
        try {
            con = this.ds.getConnection();
            updateHi = con.prepareStatement(this.updateHiSql);
            updateHi.setLong(1, newHi);
            updateHi.setLong(2, curHi);
            bl = updateHi.executeUpdate() == 1;
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(updateHi);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(updateHi);
        JDBCUtil.safeClose(con);
        return bl;
    }
}

