/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.net.URL;
import java.util.List;
import org.jboss.deployers.spi.structure.MetaDataTypeFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.JSFDeployment;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileFilterWithAttributes;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.web.deployers.FacesConfigParsingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigParsingDeployer
extends AbstractVFSParsingDeployer<JSFDeployment> {
    private static final Logger logger = Logger.getLogger(FacesConfigParsingDeployer.class);

    public FacesConfigParsingDeployer() {
        super(JSFDeployment.class);
        this.setName("faces-config.xml");
        this.setAllowMultipleFiles(true);
    }

    protected boolean allowsReparse() {
        return true;
    }

    protected JSFDeployment parse(DeploymentUnit unit, String name, JSFDeployment output) throws Exception {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return null;
        }
        if (this.ignoreName(unit, name)) {
            return null;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        List facesConfigXmlFiles = vfsDeploymentUnit.getMetaDataFiles((VirtualFileFilter)new FacesConfigXmlFileNameMatchFilter(), MetaDataTypeFilter.ALL);
        if (facesConfigXmlFiles == null || facesConfigXmlFiles.isEmpty()) {
            return null;
        }
        JSFDeployment jsfDeployment = (JSFDeployment)vfsDeploymentUnit.getAttachment(JSFDeployment.class);
        for (VirtualFile facesConfigXmlFile : facesConfigXmlFiles) {
            if (this.ignoreFile(vfsDeploymentUnit, facesConfigXmlFile)) continue;
            jsfDeployment = this.parse(vfsDeploymentUnit, facesConfigXmlFile, jsfDeployment);
        }
        return jsfDeployment;
    }

    protected JSFDeployment parse(VFSDeploymentUnit unit, VirtualFile file, JSFDeployment jsfDeployment) throws Exception {
        URL facesConfigURL = file.toURL();
        if (jsfDeployment == null) {
            jsfDeployment = new JSFDeployment();
        }
        FacesConfigParsingUtil.parse((DeploymentUnit)unit, facesConfigURL, jsfDeployment);
        return jsfDeployment;
    }

    private class FacesConfigXmlFileNameMatchFilter
    implements VirtualFileFilterWithAttributes {
        private FacesConfigXmlFileNameMatchFilter() {
        }

        public VisitorAttributes getAttributes() {
            return VisitorAttributes.LEAVES_ONLY;
        }

        public boolean accepts(VirtualFile file) {
            if (file == null) {
                return false;
            }
            String fileName = file.getName();
            if (fileName.equals("faces-config.xml")) {
                VirtualFile parent = file.getParent();
                if (parent == null) {
                    return false;
                }
                String parentName = parent.getName();
                if (parentName.equals("META-INF") || parentName.equals("WEB-INF")) {
                    return true;
                }
            }
            return false;
        }
    }
}

