/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.IOException;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataType;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSArchiveStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;

public class WARStructure
extends AbstractVFSArchiveStructureDeployer {
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private VirtualFileFilter webInfLibFilter = DEFAULT_WEB_INF_LIB_FILTER;
    private VirtualFileFilter webInfLibMetaDataFilter;
    private boolean includeWebInfInClasspath;

    public WARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getWebInfLibFilter() {
        return this.webInfLibFilter;
    }

    public void setWebInfLibFilter(VirtualFileFilter webInfLibFilter) {
        if (webInfLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.webInfLibFilter = webInfLibFilter;
    }

    public VirtualFileFilter getWebInfLibMetaDataFilter() {
        return this.webInfLibMetaDataFilter;
    }

    public void setWebInfLibMetaDataFilter(VirtualFileFilter webInfLibMetaDataFilter) {
        this.webInfLibMetaDataFilter = webInfLibMetaDataFilter;
    }

    public void setIncludeWebInfInClasspath(boolean includeWebInfInClasspath) {
        this.includeWebInfInClasspath = includeWebInfInClasspath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doDetermineStructure(StructureContext structureContext) throws DeploymentException {
        ContextInfo context = null;
        VirtualFile file = structureContext.getFile();
        try {
            VirtualFile webinf;
            boolean trace;
            block24: {
                block23: {
                    trace = log.isTraceEnabled();
                    if (this.hasValidSuffix(file.getName())) break block23;
                    webinf = file.getChild("WEB-INF");
                    if (webinf.exists()) {
                        if (trace) {
                            log.trace((Object)"... ok - directory has a WEB-INF subdirectory");
                        }
                        break block24;
                    } else {
                        if (trace) {
                            log.trace((Object)"... no - doesn't look like a war and no WEB-INF subdirectory.");
                        }
                        return false;
                    }
                }
                if (trace) {
                    log.trace((Object)"... ok - name ends in .war.");
                }
            }
            String[] metaDataLocations = new String[]{"WEB-INF", "WEB-INF/classes/META-INF"};
            context = this.createContext(structureContext, metaDataLocations);
            webinf = file.getChild("WEB-INF");
            boolean webinfExists = webinf.exists();
            if (webinfExists) {
                List children = webinf.getChildren();
                for (VirtualFile child : children) {
                    if (WARStructure.isLeaf((VirtualFile)child) || "lib".equals(child.getName()) || "classes".equals(child.getName())) continue;
                    this.addMetaDataPath(structureContext, context, "WEB-INF/" + child.getName(), MetaDataType.ALTERNATIVE);
                    this.addPathsRecursively(structureContext, context, child, "WEB-INF/" + child.getName());
                }
            }
            List archives = null;
            try {
                VirtualFile webinfLib = file.getChild("WEB-INF/lib");
                if (webinfLib.exists()) {
                    archives = webinfLib.getChildren(this.webInfLibFilter);
                    for (VirtualFile jar : archives) {
                        VirtualFile metaInf;
                        Automounter.mount((VirtualFile)file, (VirtualFile)jar, (MountOption[])new MountOption[0]);
                        if (this.webInfLibMetaDataFilter != null && this.webInfLibMetaDataFilter != this.webInfLibFilter && !this.webInfLibMetaDataFilter.accepts(jar) || !(metaInf = jar.getChild("META-INF")).exists() || WARStructure.isLeaf((VirtualFile)metaInf)) continue;
                        this.addMetaDataPath(structureContext, context, "WEB-INF/lib/" + jar.getName() + "/META-INF", MetaDataType.ALTERNATIVE);
                        List children = metaInf.getChildren();
                        for (VirtualFile child : children) {
                            if (WARStructure.isLeaf((VirtualFile)child) || "resources".equals(child.getName())) continue;
                            this.addMetaDataPath(structureContext, context, "WEB-INF/lib/" + jar.getName() + "/META-INF/" + child.getName(), MetaDataType.ALTERNATIVE);
                            this.addPathsRecursively(structureContext, context, child, "WEB-INF/lib/" + jar.getName() + "/META-INF/" + child.getName());
                        }
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)("Exception looking for WEB-INF/lib, " + file.getPathName() + ", " + e));
            }
            this.addClassPath(structureContext, file, false, true, context);
            VirtualFile classes = file.getChild("WEB-INF/classes");
            if (classes.exists()) {
                this.addClassPath(structureContext, classes, true, false, context);
            } else if (trace) {
                log.trace((Object)("No WEB-INF/classes for: " + file.getPathName()));
            }
            if (archives != null) {
                for (VirtualFile jar : archives) {
                    this.addClassPath(structureContext, jar, true, true, context);
                }
            } else if (trace) {
                log.trace((Object)("No WEB-INF/lib for: " + file.getPathName()));
            }
            if (this.includeWebInfInClasspath && webinfExists) {
                this.addClassPath(structureContext, webinf, true, false, context);
            }
            return true;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }

    protected boolean hasValidSuffix(String name) {
        return name.toLowerCase().endsWith(".war");
    }

    protected void performMount(VirtualFile file) throws IOException {
        Automounter.mount((VirtualFile)file, (MountOption[])new MountOption[]{MountOption.EXPANDED, MountOption.COPY});
    }

    protected void addPathsRecursively(StructureContext context, ContextInfo info, VirtualFile parent, String path) throws IOException {
        List children = parent.getChildren();
        for (VirtualFile child : children) {
            if (WARStructure.isLeaf((VirtualFile)child)) continue;
            String newPath = path + "/" + child.getName();
            this.addMetaDataPath(context, info, newPath, MetaDataType.ALTERNATIVE);
            this.addPathsRecursively(context, info, child, newPath);
        }
    }
}

