/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.helpers.DefaultDeploymentContextComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyDeploymentContextComparator
extends DefaultDeploymentContextComparator {
    public static final LegacyDeploymentContextComparator INSTANCE = new LegacyDeploymentContextComparator();
    private static Map<String, Integer> legacyOrder = new HashMap<String, Integer>();
    private boolean useDefaults = true;
    private Map<String, Integer> suffixOrder;
    private Map<String, Integer> orderMap;
    private int defaultOrder = 850;

    public static LegacyDeploymentContextComparator getInstance() {
        return INSTANCE;
    }

    public int compare(DeploymentContext fst, DeploymentContext snd) {
        int sndOrder;
        int fstOrder = this.getContextOrder(fst);
        int diff = fstOrder - (sndOrder = this.getContextOrder(snd));
        if (diff != 0) {
            return diff;
        }
        return super.compare(fst, snd);
    }

    protected int getContextOrder(DeploymentContext context) {
        String simpleName = context.getSimpleName();
        for (Map.Entry<String, Integer> entry : this.getOrderMap().entrySet()) {
            if (!simpleName.endsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultOrder;
    }

    protected Map<String, Integer> getOrderMap() {
        if (this.orderMap == null) {
            this.orderMap = this.createOrderMap();
        }
        return this.orderMap;
    }

    public void create() {
    }

    public Map<String, Integer> createOrderMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (this.useDefaults) {
            map.putAll(legacyOrder);
        }
        if (this.suffixOrder != null) {
            map.putAll(this.suffixOrder);
        }
        return map;
    }

    public void setUseDefaults(boolean useDefaults) {
        this.useDefaults = useDefaults;
    }

    public void setSuffixOrder(Map<String, Integer> suffixOrder) {
        this.suffixOrder = suffixOrder;
    }

    public void setDefaultOrder(int defaultOrder) {
        this.defaultOrder = defaultOrder;
    }

    Object readResolve() {
        return INSTANCE;
    }

    static {
        legacyOrder.put(".deployer", 50);
        legacyOrder.put("-deployer.xml", 50);
        legacyOrder.put(".aop", 100);
        legacyOrder.put("-aop.xml", 100);
        legacyOrder.put(".sar", 150);
        legacyOrder.put("-service.xml", 150);
        legacyOrder.put(".beans", 200);
        legacyOrder.put("-jboss-beans.xml", 200);
        legacyOrder.put(".rar", 250);
        legacyOrder.put("-ds.xml", 300);
        legacyOrder.put(".har", 350);
        legacyOrder.put("-jms.xml", 350);
        legacyOrder.put(".jar", 400);
        legacyOrder.put(".ejb3", 400);
        legacyOrder.put(".par", 400);
        legacyOrder.put(".war", 500);
        legacyOrder.put(".wsr", 600);
        legacyOrder.put(".ear", 650);
        legacyOrder.put(".zip", 750);
        legacyOrder.put(".bsh", 800);
        legacyOrder.put(".last", 900);
    }
}

