/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.managed.spi.factory;

import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.metadata.spi.MetaData;

/**
 * ManagedObjectPopulator.
 * 
 * @param <T> the underlying object
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @author Scott.Stark@jboss.org
 * @version $Revision: 80512 $
 */
public interface ManagedObjectPopulator<T>
{
   /**
    * Create a new underlying object from clazz and construct its ManagedObject.
    * 
    * @param managedObject the managed object
    * @param clazz the class
    */
   void createObject(ManagedObject managedObject, Class<T> clazz);
   /**
    * Create a new underlying object from clazz and construct its ManagedObject.
    * 
    * @param managedObject the managed object
    * @param clazz the class
    * @param metaData - the optional metadata repository accessor used to query
    * for property annotations.
    */
   void createObject(ManagedObject managedObject, Class<T> clazz, MetaData metaData);

   /**
    * Populate the managed object with property values from the object.
    * 
    * @param managedObject the managed object to populate with values
    * @param object the object used to populate the managed object
    */
   void populateManagedObject(MutableManagedObject managedObject, T object);
   /**
    * Populate the managed object with property values from the object.
    * 
    * @param managedObject the managed object to populate with values
    * @param object the object used to populate the managed object
    * @param metaData - the optional metadata repository accessor used to query
    * for property annotations.
    */
   void populateManagedObject(MutableManagedObject managedObject, T object,
         MetaData metaData);
}
