/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.ResourceAuthorityType;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceSharingScopeType;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.ee.ResourceInjectionMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class ResourceReferenceMetaDataParser
extends MetaDataElementParser {
    public static ResourceReferenceMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        ResourceReferenceMetaData resourceReference = new ResourceReferenceMetaData();
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    resourceReference.setId(value);
                    continue block11;
                }
                default: {
                    throw ResourceReferenceMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions)) {
                if (resourceReference.getDescriptions() != null) continue;
                resourceReference.setDescriptions(descriptions);
                continue;
            }
            if (ResourceInjectionMetaDataParser.parse(reader, resourceReference)) continue;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RES_REF_NAME: {
                    resourceReference.setResourceRefName(ResourceReferenceMetaDataParser.getElementText(reader));
                    continue block12;
                }
                case RES_TYPE: {
                    resourceReference.setType(ResourceReferenceMetaDataParser.getElementText(reader));
                    continue block12;
                }
                case RES_AUTH: {
                    resourceReference.setResAuth(ResourceAuthorityType.valueOf(ResourceReferenceMetaDataParser.getElementText(reader)));
                    continue block12;
                }
                case RES_SHARING_SCOPE: {
                    resourceReference.setResSharingScope(ResourceSharingScopeType.valueOf(ResourceReferenceMetaDataParser.getElementText(reader)));
                    continue block12;
                }
                case RESOURCE_NAME: {
                    resourceReference.setResourceName(ResourceReferenceMetaDataParser.getElementText(reader));
                    continue block12;
                }
                case RES_URL: {
                    resourceReference.setResUrl(ResourceReferenceMetaDataParser.getElementText(reader));
                    continue block12;
                }
            }
            throw ResourceReferenceMetaDataParser.unexpectedElement(reader);
        }
        return resourceReference;
    }
}

