/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.subsystem.web.MigrateWebSubsystem;

public class EAP7_1MigrateWebSubsystem<S>
extends MigrateWebSubsystem<S> {
    public EAP7_1MigrateWebSubsystem() {
        this(new EAP7_1MigrateWebSubsystemSubtaskBuilder());
    }

    protected EAP7_1MigrateWebSubsystem(EAP7_1MigrateWebSubsystemSubtaskBuilder<S> subtaskBuilder) {
        super(subtaskBuilder);
    }

    protected static class EAP7_1MigrateWebSubsystemSubtaskBuilder<S>
    extends MigrateWebSubsystem.MigrateWebSubsystemSubtaskBuilder<S> {
        private static final String CONNECTOR = "connector";
        private static final String CONFIGURATION = "configuration";
        private static final String SSL = "ssl";
        private static final String SERVER = "server";
        private static final String DEFAULT_SERVER = "default-server";
        private static final String HTTPS_LISTENER = "https-listener";
        private static final String SSL_CONTEXT = "ssl-context";
        private static final String SECURITY_REALM = "security-realm";
        private static final String CA_CERTIFICATE_FILE = "ca-certificate-file";
        private static final String CA_CERTIFICATE_PASSWORD = "ca-certificate-password";
        private static final String CERTIFICATE_KEY_FILE = "certificate-key-file";
        private static final String CIPHER_SUITE = "cipher-suite";
        private static final String KEY_ALIAS = "key-alias";
        private static final String KEYSTORE_TYPE = "keystore-type";
        private static final String PASSWORD = "password";
        private static final String PROTOCOL = "protocol";
        private static final String SESSION_CACHE_SIZE = "session-cache-size";
        private static final String SESSION_TIMEOUT = "session-timeout";
        private static final String TRUSTSTORE_TYPE = "truststore-type";
        private static final String VERIFY_CLIENT = "verify-client";
        private static final String SSL_SESSION_CACHE_SIZE = "ssl-session-cache-size";
        private static final String SSL_SESSION_TIMEOUT = "ssl-session-timeout";
        private static final String PATH = "path";
        private static final String TYPE = "type";
        private static final String CREDENTIAL_REFERENCE = "credential-reference";
        private static final String MAXIMUM_SESSION_CACHE_SIZE = "maximum-session-cache-size";
        private static final String KEY_MANAGER = "key-manager";
        private static final String KEY_STORE = "key-store";
        private static final String SERVER_SSL_CONTEXT = "server-ssl-context";
        private static final String CLEAR_TEXT = "clear-text";
        private static final String TRUST_MANAGER = "trust-manager";
        private static final String CIPHER_SUITE_FILTER = "cipher-suite-filter";
        private static final String WANT_CLIENT_AUTH = "want-client-auth";
        private static final String NEED_CLIENT_AUTH = "need-client-auth";
        private static final String ALIAS_FILTER = "alias-filter";
        private static final String PROTOCOLS = "protocols";

        protected EAP7_1MigrateWebSubsystemSubtaskBuilder() {
        }

        protected ServerMigrationTaskResult migrateConfiguration(SubsystemResource webSubsystemResource, TaskContext taskContext) {
            ServerMigrationTaskResult taskResult;
            ModelNode webSubsystemConfig = webSubsystemResource.getResourceConfiguration();
            HashMap<String, ModelNode> sslConfigs = new HashMap<String, ModelNode>();
            if (webSubsystemConfig.hasDefined(CONNECTOR)) {
                for (String connectorName : webSubsystemConfig.get(CONNECTOR).keys()) {
                    ModelNode sslConfig = webSubsystemConfig.get(new String[]{CONNECTOR, connectorName, CONFIGURATION, SSL});
                    if (!sslConfig.isDefined()) continue;
                    sslConfigs.put(connectorName, sslConfig.clone());
                }
            }
            if ((taskResult = super.migrateConfiguration(webSubsystemResource, taskContext)).getStatus() == ServerMigrationTaskResult.Status.SUCCESS && !sslConfigs.isEmpty()) {
                SubsystemResource undertowSubsystemResource = webSubsystemResource.getParentResource().getSubsystemResource("undertow");
                ModelNode undertowDefaultServerConfig = undertowSubsystemResource.getResourceConfiguration().get(new String[]{SERVER, DEFAULT_SERVER});
                for (Map.Entry entry : sslConfigs.entrySet()) {
                    this.updateSslConfig((String)entry.getKey(), (ModelNode)entry.getValue(), undertowSubsystemResource, undertowDefaultServerConfig, taskContext);
                }
            }
            return taskResult;
        }

        protected void updateSslConfig(String connector, ModelNode sslConfig, SubsystemResource undertowSubsystemResource, ModelNode undertowDefaultServerConfig, TaskContext taskContext) {
            ModelNode httpsListener = undertowDefaultServerConfig.get(new String[]{HTTPS_LISTENER, connector});
            if (httpsListener.isDefined() && httpsListener.hasDefined(SECURITY_REALM)) {
                ModelNode keyAlias = sslConfig.get(KEY_ALIAS);
                ModelNode password = sslConfig.get(PASSWORD);
                ModelNode certificateKeyFile = sslConfig.get(CERTIFICATE_KEY_FILE);
                ModelNode cipherSuite = sslConfig.get(CIPHER_SUITE);
                ModelNode protocol = sslConfig.get(PROTOCOL);
                ModelNode verifyClient = sslConfig.get(VERIFY_CLIENT);
                ModelNode caCertificateFile = sslConfig.get(CA_CERTIFICATE_FILE);
                ModelNode caCertificatePassword = sslConfig.get(CA_CERTIFICATE_PASSWORD);
                ModelNode trustStoreType = sslConfig.get(TRUSTSTORE_TYPE);
                ModelNode keystoreType = sslConfig.get(KEYSTORE_TYPE);
                ModelNode sessionCacheSize = sslConfig.get(SESSION_CACHE_SIZE);
                ModelNode sessionTimeout = sslConfig.get(SESSION_TIMEOUT);
                Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
                ManageableServerConfiguration serverConfiguration = undertowSubsystemResource.getServerConfiguration();
                if (!serverConfiguration.hasExtensionResource("org.wildfly.extension.elytron")) {
                    ModelNode op = Util.createAddOperation((PathAddress)serverConfiguration.getExtensionResourcePathAddress("org.wildfly.extension.elytron"));
                    op.get("module").set("org.wildfly.extension.elytron");
                    compositeOperationBuilder.addStep(op);
                }
                PathAddress subsystemAddress = undertowSubsystemResource.getParentResource().getSubsystemResourcePathAddress("elytron");
                if (!undertowSubsystemResource.getParentResource().hasSubsystemResource("elytron")) {
                    ModelNode op = Util.createAddOperation((PathAddress)subsystemAddress);
                    compositeOperationBuilder.addStep(op);
                }
                String resourceNamePrefix = "jbossweb-migrated-connector-" + connector;
                String keystoreName = connector + "-" + KEY_STORE;
                PathAddress keystoreAddress = subsystemAddress.append(KEY_STORE, keystoreName);
                ModelNode keystoreAddOp = Util.createAddOperation((PathAddress)keystoreAddress);
                if (certificateKeyFile.isDefined()) {
                    keystoreAddOp.get(PATH).set(certificateKeyFile);
                } else {
                    keystoreAddOp.get(PATH).set("${user.home}/.keystore");
                }
                ModelNode keystoreCredentialReference = new ModelNode();
                keystoreCredentialReference.get(CLEAR_TEXT).set(password);
                keystoreAddOp.get(CREDENTIAL_REFERENCE).set(keystoreCredentialReference);
                if (keystoreType.isDefined()) {
                    keystoreAddOp.get(TYPE).set(keystoreType);
                } else {
                    keystoreAddOp.get(TYPE).set("JKS");
                }
                compositeOperationBuilder.addStep(keystoreAddOp);
                String keyManagerName = resourceNamePrefix + "-" + KEY_MANAGER;
                PathAddress keyManagerAddress = subsystemAddress.append(KEY_MANAGER, keyManagerName);
                ModelNode keyManagerAddOp = Util.createAddOperation((PathAddress)keyManagerAddress);
                keyManagerAddOp.get(KEY_STORE).set(keystoreName);
                if (keyAlias.isDefined()) {
                    keyManagerAddOp.get(ALIAS_FILTER).set(keyAlias);
                }
                keyManagerAddOp.get(CREDENTIAL_REFERENCE).set(keystoreCredentialReference.clone());
                compositeOperationBuilder.addStep(keyManagerAddOp);
                String serverSslContextName = resourceNamePrefix + "-" + SERVER_SSL_CONTEXT;
                PathAddress serverSslContextAddress = subsystemAddress.append(SERVER_SSL_CONTEXT, serverSslContextName);
                ModelNode serverSslContextAddOp = Util.createAddOperation((PathAddress)serverSslContextAddress);
                serverSslContextAddOp.get(KEY_MANAGER).set(keyManagerName);
                if (sessionCacheSize.isDefined()) {
                    serverSslContextAddOp.get(MAXIMUM_SESSION_CACHE_SIZE).set(sessionCacheSize);
                }
                if (sessionTimeout.isDefined()) {
                    serverSslContextAddOp.get(SESSION_TIMEOUT).set(sessionTimeout);
                }
                if (protocol.isDefined()) {
                    Object protocols = new HashSet();
                    switch (protocol.asString()) {
                        case "ALL": {
                            break;
                        }
                        case "SSLv2Hello": {
                            break;
                        }
                        case "SSLv2+SSLv3": {
                            protocols.add("SSLv2");
                            protocols.add("SSLv3");
                            break;
                        }
                        default: {
                            protocols.add(protocol.asString());
                        }
                    }
                    if (!protocols.isEmpty()) {
                        ModelNode modelNode = new ModelNode().setEmptyList();
                        Iterator iterator = protocols.iterator();
                        while (iterator.hasNext()) {
                            String s = (String)iterator.next();
                            modelNode.add(s);
                        }
                        serverSslContextAddOp.get(PROTOCOLS).set(modelNode);
                    }
                }
                if (cipherSuite.isDefined()) {
                    serverSslContextAddOp.get(CIPHER_SUITE_FILTER).set(cipherSuite);
                }
                if (verifyClient.isDefined()) {
                    switch (verifyClient.asString()) {
                        case "optionalNoCA": 
                        case "optional": {
                            serverSslContextAddOp.get(WANT_CLIENT_AUTH).set(true);
                            break;
                        }
                        case "true": 
                        case "require": {
                            serverSslContextAddOp.get(NEED_CLIENT_AUTH).set(true);
                            break;
                        }
                    }
                }
                compositeOperationBuilder.addStep(serverSslContextAddOp);
                if (caCertificateFile.isDefined()) {
                    ModelNode trustStoreCredentialReference;
                    String trustStoreName = resourceNamePrefix + "-trust-store";
                    PathAddress trustStoreAddress = subsystemAddress.append(KEY_STORE, trustStoreName);
                    ModelNode trustStoreAddOp = Util.createAddOperation((PathAddress)trustStoreAddress);
                    trustStoreAddOp.get(PATH).set(caCertificateFile);
                    if (!caCertificatePassword.isDefined()) {
                        trustStoreCredentialReference = keystoreCredentialReference.clone();
                    } else {
                        trustStoreCredentialReference = new ModelNode();
                        trustStoreCredentialReference.get(CLEAR_TEXT).set(caCertificatePassword);
                    }
                    trustStoreAddOp.get(CREDENTIAL_REFERENCE).set(trustStoreCredentialReference);
                    if (trustStoreType.isDefined()) {
                        trustStoreAddOp.get(TYPE).set(trustStoreType);
                    } else {
                        trustStoreAddOp.get(TYPE).set("JKS");
                    }
                    compositeOperationBuilder.addStep(trustStoreAddOp);
                    String trustManagerName = resourceNamePrefix + "-" + TRUST_MANAGER;
                    PathAddress trustManagerAddress = subsystemAddress.append(TRUST_MANAGER, trustManagerName);
                    ModelNode trustManagerAddOp = Util.createAddOperation((PathAddress)trustManagerAddress);
                    trustManagerAddOp.get(KEY_STORE).set(trustStoreName);
                    trustManagerAddOp.get(CREDENTIAL_REFERENCE).set(trustStoreCredentialReference.clone());
                    compositeOperationBuilder.addStep(trustManagerAddOp);
                    serverSslContextAddOp.get(TRUST_MANAGER).set(trustManagerName);
                }
                PathAddress undertowConnectorAddress = undertowSubsystemResource.getResourcePathAddress().append(SERVER, DEFAULT_SERVER).append(HTTPS_LISTENER, connector);
                compositeOperationBuilder.addStep(Util.getUndefineAttributeOperation((PathAddress)undertowConnectorAddress, (String)SECURITY_REALM));
                compositeOperationBuilder.addStep(Util.getUndefineAttributeOperation((PathAddress)undertowConnectorAddress, (String)VERIFY_CLIENT));
                compositeOperationBuilder.addStep(Util.getUndefineAttributeOperation((PathAddress)undertowConnectorAddress, (String)"enabled-cipher-suites"));
                compositeOperationBuilder.addStep(Util.getUndefineAttributeOperation((PathAddress)undertowConnectorAddress, (String)"enabled-protocols"));
                compositeOperationBuilder.addStep(Util.getUndefineAttributeOperation((PathAddress)undertowConnectorAddress, (String)SSL_SESSION_CACHE_SIZE));
                compositeOperationBuilder.addStep(Util.getUndefineAttributeOperation((PathAddress)undertowConnectorAddress, (String)SSL_SESSION_TIMEOUT));
                compositeOperationBuilder.addStep(Util.getWriteAttributeOperation((PathAddress)undertowConnectorAddress, (String)SSL_CONTEXT, (String)serverSslContextName));
                serverConfiguration.executeManagementOperation(compositeOperationBuilder.build().getOperation());
            }
        }
    }
}

