/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.PathUtils;

final class StreamUtil {
    StreamUtil() {
    }

    static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static void safeClose(ZipFile closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void unzip(File src, File destDir) throws IOException {
        String absolutePath = destDir.getAbsolutePath();
        ZipFile zip = new ZipFile(src);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File fp = new File(absolutePath, PathUtils.canonicalize(PathUtils.relativize(entry.getName())));
                File parent = fp.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                InputStream is = zip.getInputStream(entry);
                try {
                    FileOutputStream os = new FileOutputStream(fp);
                    try {
                        StreamUtil.copy(is, os);
                    }
                    finally {
                        StreamUtil.safeClose(os);
                    }
                }
                finally {
                    StreamUtil.safeClose(is);
                }
            }
        }
        finally {
            StreamUtil.safeClose(zip);
        }
    }
}

