/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.bridge.inbound;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.bridge.inbound.InboundBridge;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeManager;
import org.jboss.narayana.rest.integration.api.Aborted;
import org.jboss.narayana.rest.integration.api.HeuristicException;
import org.jboss.narayana.rest.integration.api.HeuristicType;
import org.jboss.narayana.rest.integration.api.Participant;
import org.jboss.narayana.rest.integration.api.ParticipantException;
import org.jboss.narayana.rest.integration.api.Prepared;
import org.jboss.narayana.rest.integration.api.ReadOnly;
import org.jboss.narayana.rest.integration.api.Vote;

public class InboundBridgeParticipant
implements Participant,
Serializable {
    private static final Logger LOG = Logger.getLogger(InboundBridgeParticipant.class);
    private final Xid xid;

    public InboundBridgeParticipant(Xid xid) {
        this.xid = xid;
    }

    public Vote prepare() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeParticipant.prepare: xid=" + this.xid));
        }
        this.startBridge();
        Vote outcome = this.prepareSubordinate();
        if (!(outcome instanceof Prepared)) {
            this.cleanup();
        } else {
            this.stopBridge();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeParticipant.prepare: xid=" + this.xid + ", outcome=" + outcome.getClass().getName()));
        }
        return outcome;
    }

    public void commit() throws HeuristicException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeParticipant.commit: xid=" + this.xid));
        }
        this.startBridge();
        try {
            this.commitSubordinate();
        }
        finally {
            this.cleanup();
        }
    }

    public void commitOnePhase() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeParticipant.commitOnePhase: xid=" + this.xid));
        }
        this.startBridge();
        Vote outcome = this.prepareSubordinate();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeParticipant.commitOnePhase: xid=" + this.xid + ", outcome=" + outcome));
        }
        if (outcome instanceof Prepared) {
            try {
                this.commitSubordinate();
            }
            catch (HeuristicException heuristicException) {
                // empty catch block
            }
        }
        this.cleanup();
    }

    public void rollback() throws HeuristicException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeParticipant.rollback: xid=" + this.xid));
        }
        this.startBridge();
        try {
            this.rollbackSubordinate();
        }
        finally {
            this.cleanup();
        }
    }

    private void startBridge() {
        InboundBridge inboundBridge = this.getInboundBridge();
        if (inboundBridge == null) {
            throw new ParticipantException("Inbound bridge is not available.");
        }
        inboundBridge.start();
    }

    private void stopBridge() {
        InboundBridge inboundBridge = this.getInboundBridge();
        if (inboundBridge != null) {
            try {
                inboundBridge.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Vote prepareSubordinate() {
        InboundBridge inboundBridge = this.getInboundBridge();
        int prepareResult = -1;
        try {
            if (inboundBridge != null) {
                prepareResult = SubordinationManager.getXATerminator().prepare(inboundBridge.getXid());
            }
        }
        catch (XAException xAException) {
            // empty catch block
        }
        return this.prepareResultToVote(prepareResult);
    }

    private void commitSubordinate() throws HeuristicException {
        InboundBridge inboundBridge = this.getInboundBridge();
        try {
            if (inboundBridge != null) {
                SubordinationManager.getXATerminator().commit(inboundBridge.getXid(), false);
            }
        }
        catch (XAException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            switch (e.errorCode) {
                case 7: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_COMMIT);
                }
                case 6: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_ROLLBACK);
                }
                case 5: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_MIXED);
                }
                case 8: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_MIXED);
                }
            }
        }
    }

    private void rollbackSubordinate() throws HeuristicException {
        InboundBridge inboundBridge = this.getInboundBridge();
        try {
            if (inboundBridge != null) {
                SubordinationManager.getXATerminator().rollback(inboundBridge.getXid());
            }
        }
        catch (XAException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            switch (e.errorCode) {
                case 7: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_COMMIT);
                }
                case 6: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_ROLLBACK);
                }
                case 5: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_MIXED);
                }
                case 8: {
                    throw new HeuristicException(HeuristicType.HEURISTIC_MIXED);
                }
            }
        }
    }

    private void cleanup() {
        this.stopBridge();
        InboundBridgeManager.getInstance().removeInboundBridge(this.xid);
    }

    private InboundBridge getInboundBridge() {
        return InboundBridgeManager.getInstance().getInboundBridge(this.xid);
    }

    private Vote prepareResultToVote(int prepareResult) {
        if (prepareResult == 0) {
            return new Prepared();
        }
        if (prepareResult == 3) {
            return new ReadOnly();
        }
        return new Aborted();
    }
}

