/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.DynamicMetaDataInternal;
import org.jboss.osgi.metadata.ManifestMetaDataInternal;
import org.jboss.osgi.metadata.MetadataLogger;
import org.jboss.osgi.metadata.MetadataMessages;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class OSGiMetaDataBuilder {
    private DynamicMetaDataInternal metadata;
    private Map<String, String> importPackages = new LinkedHashMap<String, String>();
    private Map<String, String> exportPackages = new LinkedHashMap<String, String>();
    private Map<String, String> requiredBundles = new LinkedHashMap<String, String>();
    private Map<String, String> dynamicImportPackages = new LinkedHashMap<String, String>();

    public static OSGiMetaDataBuilder createBuilder(String symbolicName) {
        if (symbolicName == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("symbolicName");
        }
        return new OSGiMetaDataBuilder(symbolicName, Version.emptyVersion);
    }

    public static OSGiMetaDataBuilder createBuilder(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("symbolicName");
        }
        if (version == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("version");
        }
        return new OSGiMetaDataBuilder(symbolicName, version);
    }

    public static OSGiMetaDataBuilder createBuilder(Dictionary<String, String> headers) {
        if (headers == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("headers");
        }
        String symbolicName = headers.get("Bundle-SymbolicName");
        Version version = Version.parseVersion((String)headers.get("Bundle-Version"));
        OSGiMetaDataBuilder builder = new OSGiMetaDataBuilder(symbolicName, version);
        Enumeration<String> keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = headers.get(key);
            builder.addMainAttribute(key, value);
        }
        return builder;
    }

    public static OSGiMetaData load(Properties props) {
        if (props == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("props");
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        for (Object key : props.keySet()) {
            Attributes.Name name = new Attributes.Name((String)key);
            mainAttributes.put(name, props.get(key));
        }
        return OSGiMetaDataBuilder.load(manifest);
    }

    public static OSGiMetaData load(Manifest manifest) {
        if (manifest == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("manifest");
        }
        return new ManifestMetaDataInternal(manifest);
    }

    public static boolean isValidMetadata(OSGiMetaData metadata) {
        if (metadata == null) {
            return false;
        }
        try {
            OSGiMetaDataBuilder.validateMetadata(metadata);
            return true;
        }
        catch (BundleException e) {
            return false;
        }
    }

    public static void validateMetadata(OSGiMetaData metadata) throws BundleException {
        if (metadata == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("metadata");
        }
        try {
            int manifestVersion = OSGiMetaDataBuilder.getBundleManifestVersion(metadata);
            if (manifestVersion < 0) {
                throw MetadataMessages.MESSAGES.bundleCannotObtainBundleManifestVersion();
            }
            if (manifestVersion > 2) {
                throw MetadataMessages.MESSAGES.bundleUnsupportedBundleManifestVersion(manifestVersion);
            }
            String symbolicName = metadata.getBundleSymbolicName();
            if (manifestVersion == 1 && symbolicName != null) {
                throw MetadataMessages.MESSAGES.bundleInvalidBundleManifestVersion(symbolicName);
            }
            if (manifestVersion == 2 && symbolicName == null) {
                throw MetadataMessages.MESSAGES.bundleCannotObtainBundleSymbolicName();
            }
        }
        catch (RuntimeException ex) {
            throw MetadataMessages.MESSAGES.bundleInvalidMetadata(ex);
        }
    }

    private static int getBundleManifestVersion(OSGiMetaData metaData) {
        String bundleName = metaData.getBundleName();
        String bundleSymbolicName = metaData.getBundleSymbolicName();
        Version bundleVersion = metaData.getBundleVersion();
        if (bundleName == null && bundleSymbolicName == null && bundleVersion.equals((Object)Version.emptyVersion)) {
            return -1;
        }
        Integer manifestVersion = metaData.getBundleManifestVersion();
        return manifestVersion != null ? manifestVersion : 1;
    }

    private OSGiMetaDataBuilder(String symbolicName, Version version) {
        this.metadata = new DynamicMetaDataInternal(symbolicName, version);
    }

    public OSGiMetaDataBuilder setBundleManifestVersion(int version) {
        this.metadata.addMainAttribute("Bundle-ManifestVersion", "" + version);
        return this;
    }

    public OSGiMetaDataBuilder setBundleActivator(String value) {
        this.metadata.addMainAttribute("Bundle-Activator", value);
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.addEntry(this.importPackages, aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addExportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.addEntry(this.exportPackages, aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addDynamicImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.addEntry(this.dynamicImportPackages, aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addRequiredBundles(String ... required) {
        for (String aux : required) {
            this.addEntry(this.requiredBundles, aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addMainAttribute(String key, String value) {
        this.metadata.addMainAttribute(key, value);
        return this;
    }

    public OSGiMetaData getAndValidateMetaData() throws BundleException {
        OSGiMetaData metadata = this.getMetaDataInternal();
        OSGiMetaDataBuilder.validateMetadata(metadata);
        return metadata;
    }

    private void addEntry(Map<String, String> target, String entry) {
        String key = entry;
        int index = entry.indexOf(";");
        if (index > 0) {
            key = entry.substring(0, index);
        }
        if (target.get(key) == null) {
            target.put(key, entry);
        } else {
            MetadataLogger.LOGGER.warnIgnoreDuplicateEntry(entry);
        }
    }

    private OSGiMetaData getMetaDataInternal() {
        this.addManifestHeader("Export-Package", this.exportPackages);
        this.addManifestHeader("Import-Package", this.importPackages);
        this.addManifestHeader("Require-Bundle", this.requiredBundles);
        this.addManifestHeader("DynamicImport-Package", this.dynamicImportPackages);
        return this.metadata;
    }

    private void addManifestHeader(String header, Map<String, String> source) {
        if (source.size() > 0) {
            int i = 0;
            StringBuffer buffer = new StringBuffer();
            for (String entry : source.values()) {
                buffer.append(i++ > 0 ? "," : "");
                buffer.append(entry);
            }
            this.metadata.addMainAttribute(header, buffer.toString());
        }
    }

    public OSGiMetaData getOSGiMetaData() {
        return this.getMetaDataInternal();
    }
}

