/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.capability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.OSGiRuntimeHelper;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public abstract class Capability {
    private static final Logger log = Logger.getLogger(Capability.class);
    private String serviceName;
    private String filter;
    private Map<String, String> systemProperties;
    private List<Capability> dependencies;
    private List<BundleInfo> bundles;
    private List<OSGiBundle> installed = new ArrayList<OSGiBundle>();

    public Capability(String serviceName) {
        this(serviceName, null);
    }

    public Capability(String serviceName, String filter) {
        this.serviceName = serviceName;
        this.filter = filter;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void addSystemProperty(String key, String value) {
        this.getPropertiesInternal().put(key, value);
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.getPropertiesInternal());
    }

    public List<Capability> getDependencies() {
        return Collections.unmodifiableList(this.getDependenciesInternal());
    }

    protected void addDependency(Capability dependency) {
        this.getDependenciesInternal().add(dependency);
    }

    public List<BundleInfo> getBundles() {
        return Collections.unmodifiableList(this.getBundlesInternal());
    }

    protected void addBundle(String location) {
        BundleInfo info;
        try {
            info = BundleInfo.createBundleInfo(location);
        }
        catch (BundleException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalArgumentException("Cannot create bundle info for: " + location, ex);
        }
        this.getBundlesInternal().add(info);
    }

    private Map<String, String> getPropertiesInternal() {
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap<String, String>();
        }
        return this.systemProperties;
    }

    private List<Capability> getDependenciesInternal() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Capability>();
        }
        return this.dependencies;
    }

    private List<BundleInfo> getBundlesInternal() {
        if (this.bundles == null) {
            this.bundles = new ArrayList<BundleInfo>();
        }
        return this.bundles;
    }

    public List<OSGiBundle> getInstalledBundles() {
        return Collections.unmodifiableList(this.installed);
    }

    public void install(OSGiRuntime runtime) throws BundleException {
        log.debug((Object)("Install capability: " + this));
        for (BundleInfo info : this.getBundles()) {
            Version version;
            String location = info.getLocation();
            String symName = info.getSymbolicName();
            if (runtime.getBundle(symName, version = info.getVersion()) == null) {
                OSGiBundle bundle = runtime.installBundle(location);
                this.installed.add(bundle);
                continue;
            }
            log.debug((Object)("Skip bundle: " + location));
        }
    }

    public void start(OSGiRuntime runtime) throws BundleException {
        log.debug((Object)("Start capability: " + this));
        for (OSGiBundle bundle : this.getInstalledBundles()) {
            bundle.start();
        }
    }

    public void stop(OSGiRuntime runtime) {
        log.debug((Object)("Stop capability: " + this));
        ArrayList<OSGiBundle> installedReverse = new ArrayList<OSGiBundle>(this.getInstalledBundles());
        Collections.reverse(installedReverse);
        for (OSGiBundle bundle : installedReverse) {
            if (bundle.getState() == 1) continue;
            OSGiRuntimeHelper.failsafeStop(bundle);
        }
    }

    public void uninstall(OSGiRuntime runtime) {
        log.debug((Object)("Uninstall capability: " + this));
        ArrayList<OSGiBundle> installedReverse = new ArrayList<OSGiBundle>(this.getInstalledBundles());
        Collections.reverse(installedReverse);
        for (OSGiBundle bundle : installedReverse) {
            if (bundle.getState() != 1) {
                OSGiRuntimeHelper.failsafeUninstall(bundle);
            }
            this.installed.remove(bundle);
        }
    }
}

