/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.osgi.framework.Version;

public final class OSGiManifestBuilder
implements Asset {
    private static final Logger log = Logger.getLogger(OSGiManifestBuilder.class);
    private StringWriter sw;
    private PrintWriter pw;
    private Set<String> importPackages = new LinkedHashSet<String>();
    private Set<String> exportPackages = new LinkedHashSet<String>();
    private Set<String> dynamicImportPackages = new LinkedHashSet<String>();
    private Set<String> requiredBundles = new LinkedHashSet<String>();
    private Set<String> requiredEnvironments = new LinkedHashSet<String>();
    private Manifest manifest;

    public static OSGiManifestBuilder newInstance() {
        return new OSGiManifestBuilder();
    }

    private OSGiManifestBuilder() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.append(Attributes.Name.MANIFEST_VERSION + ": 1.0", true);
    }

    public OSGiManifestBuilder addBundleManifestVersion(int version) {
        this.append("Bundle-ManifestVersion: " + version, true);
        return this;
    }

    public OSGiManifestBuilder addBundleSymbolicName(String symbolicName) {
        this.append("Bundle-SymbolicName: " + symbolicName, true);
        return this;
    }

    public OSGiManifestBuilder addBundleName(String name) {
        this.append("Bundle-Name: " + name, true);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(Version version) {
        this.append("Bundle-Version: " + version, true);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(String version) {
        return this.addBundleVersion(Version.parseVersion((String)version));
    }

    public OSGiManifestBuilder addBundleActivator(Class<?> bundleActivator) {
        return this.addBundleActivator(bundleActivator.getName());
    }

    public OSGiManifestBuilder addBundleActivator(String bundleActivator) {
        this.append("Bundle-Activator: " + bundleActivator, true);
        return this;
    }

    public OSGiManifestBuilder addBundleActivationPolicy(String activationPolicy) {
        this.append("Bundle-ActivationPolicy: " + activationPolicy, true);
        return this;
    }

    public OSGiManifestBuilder addFragmentHost(String fragmentHost) {
        this.append("Fragment-Host: " + fragmentHost, true);
        return this;
    }

    public OSGiManifestBuilder addRequireBundle(String requiredBundle) {
        this.requiredBundles.add(requiredBundle);
        return this;
    }

    public OSGiManifestBuilder addRequireExecutionEnvironment(String ... environments) {
        for (String aux : environments) {
            this.requiredEnvironments.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.importPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.importPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.dynamicImportPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.exportPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.exportPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addManifestHeader(String key, String value) {
        this.append(key + ": " + value, true);
        return this;
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            Iterator<String> iterator;
            if (this.requiredBundles.size() > 0) {
                this.append("Require-Bundle: ", false);
                iterator = this.requiredBundles.iterator();
                this.append(iterator.next(), false);
                while (iterator.hasNext()) {
                    this.append("," + iterator.next(), false);
                }
                this.append(null, true);
            }
            if (this.requiredEnvironments.size() > 0) {
                this.append("Bundle-RequiredExecutionEnvironment: ", false);
                iterator = this.requiredEnvironments.iterator();
                this.append(iterator.next(), false);
                while (iterator.hasNext()) {
                    this.append("," + iterator.next(), false);
                }
                this.append(null, true);
            }
            if (this.exportPackages.size() > 0) {
                this.append("Export-Package: ", false);
                iterator = this.exportPackages.iterator();
                this.append(iterator.next(), false);
                while (iterator.hasNext()) {
                    this.append("," + iterator.next(), false);
                }
                this.append(null, true);
            }
            if (this.importPackages.size() > 0) {
                this.append("Import-Package: ", false);
                iterator = this.importPackages.iterator();
                this.append(iterator.next(), false);
                while (iterator.hasNext()) {
                    this.append("," + iterator.next(), false);
                }
                this.append(null, true);
            }
            if (this.dynamicImportPackages.size() > 0) {
                this.append("DynamicImport-Package: ", false);
                iterator = this.dynamicImportPackages.iterator();
                this.append(iterator.next(), false);
                while (iterator.hasNext()) {
                    this.append("," + iterator.next(), false);
                }
                this.append(null, true);
            }
            String manifestString = this.sw.toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)manifestString);
            }
            try {
                this.manifest = new Manifest(new ByteArrayInputStream(manifestString.getBytes()));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create manifest", ex);
            }
        }
        return this.manifest;
    }

    public InputStream openStream() {
        Manifest manifest = this.getManifest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot provide manifest InputStream", ex);
        }
    }

    private void append(String line, boolean newline) {
        if (this.manifest != null) {
            throw new IllegalStateException("Cannot append to already existing manifest");
        }
        if (line != null) {
            this.pw.print(line);
        }
        if (newline) {
            this.pw.println();
        }
    }
}

