/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOError;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.RemotingXmlParser;
import org.jboss.remoting3.UncloseableEndpoint;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.spi.EndpointConfigurator;
import org.wildfly.client.config.ConfigXMLParseException;

public final class ConfigurationEndpointSupplier
implements Supplier<Endpoint> {
    private static final Endpoint CONFIGURED_ENDPOINT = AccessController.doPrivileged(() -> {
        Endpoint endpoint = null;
        try {
            endpoint = RemotingXmlParser.parseEndpoint();
        }
        catch (IOException | ConfigXMLParseException e) {
            Messages.log.trace("Failed to parse endpoint XML definition", e);
        }
        if (endpoint == null) {
            Iterator<EndpointConfigurator> iterator = ServiceLoader.load(EndpointConfigurator.class, ConfigurationEndpointSupplier.class.getClassLoader()).iterator();
            while (endpoint == null) {
                try {
                    if (!iterator.hasNext()) break;
                    EndpointConfigurator configurator = iterator.next();
                    if (configurator == null) continue;
                    endpoint = configurator.getConfiguredEndpoint();
                }
                catch (ServiceConfigurationError e) {
                    Messages.log.trace("Failed to configure a service", e);
                }
            }
        }
        if (endpoint == null) {
            try {
                endpoint = new EndpointBuilder().build();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        return new UncloseableEndpoint(endpoint);
    });

    @Override
    public Endpoint get() {
        return CONFIGURED_ENDPOINT;
    }
}

