/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.AcceptParameterHttpPreprocessor;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.interceptors.SecurityInterceptor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.resourcefactory.JndiComponentResourceFactory;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.InternalDispatcher;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.jboss.resteasy.util.GetRestful;
import org.jboss.resteasy.util.PickConstructor;

public class ResteasyDeployment {
    protected boolean deploymentSensitiveFactoryEnabled = false;
    protected boolean asyncJobServiceEnabled = false;
    protected int asyncJobServiceMaxJobResults = 100;
    protected long asyncJobServiceMaxWait = 300000L;
    protected int asyncJobServiceThreadPoolSize = 100;
    protected String asyncJobServiceBasePath = "/asynch/jobs";
    protected String applicationClass;
    protected String injectorFactoryClass;
    protected Application application;
    protected boolean registerBuiltin = true;
    protected List<String> scannedResourceClasses = new ArrayList<String>();
    protected List<String> scannedProviderClasses = new ArrayList<String>();
    protected List<String> scannedJndiComponentResources = new ArrayList<String>();
    protected List<String> jndiComponentResources = new ArrayList<String>();
    protected List<String> providerClasses = new ArrayList<String>();
    protected List<Class> actualProviderClasses = new ArrayList<Class>();
    protected List<Object> providers = new ArrayList<Object>();
    protected boolean securityEnabled = false;
    protected List<String> jndiResources = new ArrayList<String>();
    protected List<String> resourceClasses = new ArrayList<String>();
    protected List<String> unwrappedExceptions = new ArrayList<String>();
    protected List<Class> actualResourceClasses = new ArrayList<Class>();
    protected List<ResourceFactory> resourceFactories = new ArrayList<ResourceFactory>();
    protected List<Object> resources = new ArrayList<Object>();
    protected Map<String, String> mediaTypeMappings = new HashMap<String, String>();
    protected Map<String, String> languageExtensions = new HashMap<String, String>();
    protected List<String> interceptorPrecedences = new ArrayList<String>();
    protected Map<String, String> interceptorBeforePrecedences = new HashMap<String, String>();
    protected Map<String, String> interceptorAfterPrecedences = new HashMap<String, String>();
    protected Map<Class, Object> defaultContextObjects = new HashMap<Class, Object>();
    protected Map<String, String> constructedDefaultContextObjects = new HashMap<String, String>();
    protected Registry registry;
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    protected ThreadLocalResteasyProviderFactory threadLocalProviderFactory;
    protected String paramMapping;
    private static final Logger logger = Logger.getLogger(ResteasyDeployment.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactory();
        }
        this.providerFactory.setRegisterBuiltins(this.registerBuiltin);
        if (this.deploymentSensitiveFactoryEnabled) {
            if (!(this.providerFactory instanceof ThreadLocalResteasyProviderFactory || ResteasyProviderFactory.peekInstance() != null && ResteasyProviderFactory.peekInstance() instanceof ThreadLocalResteasyProviderFactory)) {
                this.threadLocalProviderFactory = new ThreadLocalResteasyProviderFactory(this.providerFactory);
                ResteasyProviderFactory.setInstance(this.threadLocalProviderFactory);
            }
        } else {
            ResteasyProviderFactory.setInstance(this.providerFactory);
        }
        if (this.asyncJobServiceEnabled) {
            AsynchronousDispatcher asyncDispatcher = new AsynchronousDispatcher(this.providerFactory);
            asyncDispatcher.setMaxCacheSize(this.asyncJobServiceMaxJobResults);
            asyncDispatcher.setMaxWaitMilliSeconds(this.asyncJobServiceMaxWait);
            asyncDispatcher.setThreadPoolSize(this.asyncJobServiceThreadPoolSize);
            asyncDispatcher.setBasePath(this.asyncJobServiceBasePath);
            asyncDispatcher.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
            this.dispatcher = asyncDispatcher;
            asyncDispatcher.start();
        } else {
            SynchronousDispatcher dis = new SynchronousDispatcher(this.providerFactory);
            dis.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
            this.dispatcher = dis;
        }
        this.registry = this.dispatcher.getRegistry();
        this.dispatcher.getDefaultContextObjects().putAll(this.defaultContextObjects);
        this.dispatcher.getDefaultContextObjects().put(Providers.class, (Object)this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Registry.class, this.registry);
        this.dispatcher.getDefaultContextObjects().put(Dispatcher.class, this.dispatcher);
        this.dispatcher.getDefaultContextObjects().put(InternalDispatcher.class, InternalDispatcher.getInstance());
        try {
            if (this.injectorFactoryClass != null) {
                InjectorFactory injectorFactory;
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.injectorFactoryClass);
                    injectorFactory = (InjectorFactory)clazz.newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Unable to find InjectorFactory implementation.", cnfe);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to instantiate InjectorFactory implementation.", e);
                }
                this.providerFactory.setInjectorFactory(injectorFactory);
            }
            Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
            contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
            if (this.constructedDefaultContextObjects != null && this.constructedDefaultContextObjects.size() > 0) {
                for (Map.Entry entry : this.constructedDefaultContextObjects.entrySet()) {
                    Class<?> key = null;
                    try {
                        key = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getKey());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Unable to instantiate context object " + (String)entry.getKey(), e);
                    }
                    Object obj = ResteasyDeployment.createFromInjectorFactory((String)entry.getValue(), this.providerFactory);
                    logger.debug("Creating context object <" + (String)entry.getKey() + " : " + (String)entry.getValue() + ">");
                    this.defaultContextObjects.put(key, obj);
                    this.dispatcher.getDefaultContextObjects().put(key, obj);
                    contextDataMap.put(key, obj);
                }
            }
            if (this.interceptorPrecedences != null) {
                for (String string : this.interceptorPrecedences) {
                    this.providerFactory.appendInterceptorPrecedence(string.trim());
                }
            }
            if (this.interceptorBeforePrecedences != null) {
                for (Map.Entry entry : this.interceptorBeforePrecedences.entrySet()) {
                    this.providerFactory.insertInterceptorPrecedenceBefore(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
                }
            }
            if (this.interceptorAfterPrecedences != null) {
                for (Map.Entry entry : this.interceptorAfterPrecedences.entrySet()) {
                    this.providerFactory.insertInterceptorPrecedenceAfter(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
                }
            }
            if (this.securityEnabled) {
                this.providerFactory.getServerPreProcessInterceptorRegistry().register((PreProcessInterceptor)((Object)SecurityInterceptor.class));
            }
            if (this.registerBuiltin) {
                this.providerFactory.setRegisterBuiltins(true);
                RegisterBuiltin.register(this.providerFactory);
            } else {
                this.providerFactory.setRegisterBuiltins(false);
            }
            if (this.applicationClass != null) {
                this.application = ResteasyDeployment.createApplication(this.applicationClass, this.providerFactory);
            }
            this.registration();
            if (this.paramMapping != null) {
                this.dispatcher.addHttpPreprocessor(new AcceptParameterHttpPreprocessor(this.paramMapping));
            }
            if (this.mediaTypeMappings != null) {
                HashMap<String, MediaType> extMap = new HashMap<String, MediaType>();
                for (Map.Entry<String, String> ext : this.mediaTypeMappings.entrySet()) {
                    String value = ext.getValue();
                    extMap.put(ext.getKey().trim(), MediaType.valueOf((String)value.trim()));
                }
                if (this.dispatcher.getMediaTypeMappings() != null) {
                    this.dispatcher.getMediaTypeMappings().putAll(extMap);
                } else {
                    this.dispatcher.setMediaTypeMappings(extMap);
                }
            }
            if (this.languageExtensions != null) {
                if (this.dispatcher.getLanguageMappings() != null) {
                    this.dispatcher.getLanguageMappings().putAll(this.languageExtensions);
                } else {
                    this.dispatcher.setLanguageMappings(this.languageExtensions);
                }
            }
        }
        finally {
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }

    public static Application createApplication(String applicationClass, ResteasyProviderFactory providerFactory) {
        return (Application)ResteasyDeployment.createFromInjectorFactory(applicationClass, providerFactory);
    }

    public static Object createFromInjectorFactory(String classname, ResteasyProviderFactory providerFactory) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Constructor constructor = PickConstructor.pickConstructor(clazz);
        if (constructor == null) {
            throw new RuntimeException("Unable to find a public constructor for class " + clazz.getName());
        }
        ConstructorInjector constructorInjector = providerFactory.getInjectorFactory().createConstructor(constructor);
        PropertyInjector propertyInjector = providerFactory.getInjectorFactory().createPropertyInjector(clazz);
        Object obj = constructorInjector.construct();
        propertyInjector.inject(obj);
        return obj;
    }

    public void registration() {
        Class<?> clazz;
        boolean useScanning = true;
        if (this.application != null) {
            this.dispatcher.getDefaultContextObjects().put(Application.class, this.application);
            ResteasyProviderFactory.getContextDataMap().put(Application.class, this.application);
            if (this.processApplication(this.application)) {
                useScanning = false;
            }
        }
        if (useScanning && this.scannedProviderClasses != null) {
            for (String string : this.scannedProviderClasses) {
                this.registerProvider(string);
            }
        }
        if (this.providerClasses != null) {
            for (String string : this.providerClasses) {
                this.registerProvider(string);
            }
        }
        if (this.providers != null) {
            for (Object object : this.providers) {
                this.providerFactory.registerProviderInstance(object);
            }
        }
        for (Class clazz2 : this.actualProviderClasses) {
            this.providerFactory.registerProvider(clazz2);
        }
        if (useScanning && this.scannedJndiComponentResources != null) {
            for (String string : this.scannedJndiComponentResources) {
                this.registerJndiComponentResource(string);
            }
        }
        if (this.jndiComponentResources != null) {
            for (String string : this.jndiComponentResources) {
                this.registerJndiComponentResource(string);
            }
        }
        if (this.jndiResources != null) {
            for (String string : this.jndiResources) {
                this.registry.addJndiResource(string.trim());
            }
        }
        if (useScanning && this.scannedResourceClasses != null) {
            for (String string : this.scannedResourceClasses) {
                clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (this.resourceClasses != null) {
            for (String string : this.resourceClasses) {
                clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (this.resources != null) {
            for (Object object : this.resources) {
                this.registry.addSingletonResource(object);
            }
        }
        for (Class clazz3 : this.actualResourceClasses) {
            this.registry.addPerRequestResource(clazz3);
        }
        for (ResourceFactory resourceFactory : this.resourceFactories) {
            this.registry.addResourceFactory(resourceFactory);
        }
    }

    protected void registerJndiComponentResource(String resource) {
        String[] config = resource.trim().split(";");
        if (config.length < 3) {
            throw new RuntimeException("JNDI Component Resource variable is not set correctly: jndi;class;true|false comma delimited");
        }
        String jndiName = config[0];
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(config[1]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class " + config[1] + " provided to JNDI Component Resource", e);
        }
        boolean cacheRefrence = Boolean.valueOf(config[2].trim());
        JndiComponentResourceFactory factory = new JndiComponentResourceFactory(jndiName, clazz, cacheRefrence);
        this.getResourceFactories().add(factory);
    }

    public void stop() {
        if (this.asyncJobServiceEnabled) {
            ((AsynchronousDispatcher)this.dispatcher).stop();
        }
        ResteasyProviderFactory.clearInstanceIfEqual(this.threadLocalProviderFactory);
        ResteasyProviderFactory.clearInstanceIfEqual(this.providerFactory);
    }

    protected boolean processApplication(Application config) {
        logger.info("Deploying " + Application.class.getName() + ": " + config.getClass());
        boolean registered = false;
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (GetRestful.isRootResource(clazz)) {
                    this.actualResourceClasses.add(clazz);
                    registered = true;
                    continue;
                }
                if (clazz.isAnnotationPresent(Provider.class)) {
                    this.actualProviderClasses.add(clazz);
                    registered = true;
                    continue;
                }
                logger.warn("Application.getClasses() returned unknown class type: " + clazz.getName());
            }
        }
        if (config.getSingletons() != null) {
            for (Object obj : config.getSingletons()) {
                if (GetRestful.isRootResource(obj.getClass())) {
                    logger.info("Adding singleton resource " + obj.getClass().getName() + " from Application " + Application.class.getName());
                    this.resources.add(obj);
                    registered = true;
                    continue;
                }
                if (obj.getClass().isAnnotationPresent(Provider.class)) {
                    this.providers.add(obj);
                    registered = true;
                    continue;
                }
                logger.warn("Application.getSingletons() returned unknown class type: " + obj.getClass().getName());
            }
        }
        return registered;
    }

    protected void registerProvider(String clazz) {
        Class<?> provider = null;
        try {
            provider = Thread.currentThread().getContextClassLoader().loadClass(clazz.trim());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.providerFactory.registerProvider(provider);
    }

    public List<String> getJndiComponentResources() {
        return this.jndiComponentResources;
    }

    public void setJndiComponentResources(List<String> jndiComponentResources) {
        this.jndiComponentResources = jndiComponentResources;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public String getInjectorFactoryClass() {
        return this.injectorFactoryClass;
    }

    public void setInjectorFactoryClass(String injectorFactoryClass) {
        this.injectorFactoryClass = injectorFactoryClass;
    }

    public boolean isDeploymentSensitiveFactoryEnabled() {
        return this.deploymentSensitiveFactoryEnabled;
    }

    public void setDeploymentSensitiveFactoryEnabled(boolean deploymentSensitiveFactoryEnabled) {
        this.deploymentSensitiveFactoryEnabled = deploymentSensitiveFactoryEnabled;
    }

    public boolean isAsyncJobServiceEnabled() {
        return this.asyncJobServiceEnabled;
    }

    public void setAsyncJobServiceEnabled(boolean asyncJobServiceEnabled) {
        this.asyncJobServiceEnabled = asyncJobServiceEnabled;
    }

    public int getAsyncJobServiceMaxJobResults() {
        return this.asyncJobServiceMaxJobResults;
    }

    public void setAsyncJobServiceMaxJobResults(int asyncJobServiceMaxJobResults) {
        this.asyncJobServiceMaxJobResults = asyncJobServiceMaxJobResults;
    }

    public long getAsyncJobServiceMaxWait() {
        return this.asyncJobServiceMaxWait;
    }

    public void setAsyncJobServiceMaxWait(long asyncJobServiceMaxWait) {
        this.asyncJobServiceMaxWait = asyncJobServiceMaxWait;
    }

    public int getAsyncJobServiceThreadPoolSize() {
        return this.asyncJobServiceThreadPoolSize;
    }

    public void setAsyncJobServiceThreadPoolSize(int asyncJobServiceThreadPoolSize) {
        this.asyncJobServiceThreadPoolSize = asyncJobServiceThreadPoolSize;
    }

    public String getAsyncJobServiceBasePath() {
        return this.asyncJobServiceBasePath;
    }

    public void setAsyncJobServiceBasePath(String asyncJobServiceBasePath) {
        this.asyncJobServiceBasePath = asyncJobServiceBasePath;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public boolean isRegisterBuiltin() {
        return this.registerBuiltin;
    }

    public void setRegisterBuiltin(boolean registerBuiltin) {
        this.registerBuiltin = registerBuiltin;
    }

    public List<String> getProviderClasses() {
        return this.providerClasses;
    }

    public void setProviderClasses(List<String> providerClasses) {
        this.providerClasses = providerClasses;
    }

    public List<Object> getProviders() {
        return this.providers;
    }

    public void setProviders(List<Object> providers) {
        this.providers = providers;
    }

    public List<Class> getActualProviderClasses() {
        return this.actualProviderClasses;
    }

    public void setActualProviderClasses(List<Class> actualProviderClasses) {
        this.actualProviderClasses = actualProviderClasses;
    }

    public List<Class> getActualResourceClasses() {
        return this.actualResourceClasses;
    }

    public void setActualResourceClasses(List<Class> actualResourceClasses) {
        this.actualResourceClasses = actualResourceClasses;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public List<String> getJndiResources() {
        return this.jndiResources;
    }

    public void setJndiResources(List<String> jndiResources) {
        this.jndiResources = jndiResources;
    }

    public List<String> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(List<String> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public Map<String, String> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    public void setMediaTypeMappings(Map<String, String> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    public List<Object> getResources() {
        return this.resources;
    }

    public void setResources(List<Object> resources) {
        this.resources = resources;
    }

    public Map<String, String> getLanguageExtensions() {
        return this.languageExtensions;
    }

    public void setLanguageExtensions(Map<String, String> languageExtensions) {
        this.languageExtensions = languageExtensions;
    }

    public List<String> getInterceptorPrecedences() {
        return this.interceptorPrecedences;
    }

    public void setInterceptorPrecedences(List<String> interceptorPrecedences) {
        this.interceptorPrecedences = interceptorPrecedences;
    }

    public Map<String, String> getInterceptorBeforePrecedences() {
        return this.interceptorBeforePrecedences;
    }

    public void setInterceptorBeforePrecedences(Map<String, String> interceptorBeforePrecedences) {
        this.interceptorBeforePrecedences = interceptorBeforePrecedences;
    }

    public Map<String, String> getInterceptorAfterPrecedences() {
        return this.interceptorAfterPrecedences;
    }

    public void setInterceptorAfterPrecedences(Map<String, String> interceptorAfterPrecedences) {
        this.interceptorAfterPrecedences = interceptorAfterPrecedences;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setMediaTypeParamMapping(String paramMapping) {
        this.paramMapping = paramMapping;
    }

    public List<ResourceFactory> getResourceFactories() {
        return this.resourceFactories;
    }

    public void setResourceFactories(List<ResourceFactory> resourceFactories) {
        this.resourceFactories = resourceFactories;
    }

    public List<String> getUnwrappedExceptions() {
        return this.unwrappedExceptions;
    }

    public void setUnwrappedExceptions(List<String> unwrappedExceptions) {
        this.unwrappedExceptions = unwrappedExceptions;
    }

    public Map<String, String> getConstructedDefaultContextObjects() {
        return this.constructedDefaultContextObjects;
    }

    public void setConstructedDefaultContextObjects(Map<String, String> constructedDefaultContextObjects) {
        this.constructedDefaultContextObjects = constructedDefaultContextObjects;
    }

    public Map<Class, Object> getDefaultContextObjects() {
        return this.defaultContextObjects;
    }

    public void setDefaultContextObjects(Map<Class, Object> defaultContextObjects) {
        this.defaultContextObjects = defaultContextObjects;
    }

    public List<String> getScannedResourceClasses() {
        return this.scannedResourceClasses;
    }

    public void setScannedResourceClasses(List<String> scannedResourceClasses) {
        this.scannedResourceClasses = scannedResourceClasses;
    }

    public List<String> getScannedProviderClasses() {
        return this.scannedProviderClasses;
    }

    public void setScannedProviderClasses(List<String> scannedProviderClasses) {
        this.scannedProviderClasses = scannedProviderClasses;
    }

    public List<String> getScannedJndiComponentResources() {
        return this.scannedJndiComponentResources;
    }

    public void setScannedJndiComponentResources(List<String> scannedJndiComponentResources) {
        this.scannedJndiComponentResources = scannedJndiComponentResources;
    }
}

