/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.seam.deployment.DeploymentHandler;
import org.jboss.seam.deployment.Scanner;
import org.jboss.seam.deployment.URLScanner;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeploymentStrategy {
    private static final LogProvider log = Logging.getLogProvider(DeploymentStrategy.class);
    private Scanner scanner;
    private Map<String, DeploymentHandler> deploymentHandlers = new HashMap<String, DeploymentHandler>();

    public abstract void scan();

    protected Scanner getScanner() {
        if (this.scanner == null) {
            this.scanner = this.createScanner();
        }
        return this.scanner;
    }

    public abstract ClassLoader getClassLoader();

    public Map<String, DeploymentHandler> getDeploymentHandlers() {
        return this.deploymentHandlers;
    }

    public void handle(String name) {
        for (String key : this.getDeploymentHandlers().keySet()) {
            DeploymentHandler deploymentHandler = this.getDeploymentHandlers().get(key);
            deploymentHandler.handle(name, this.getClassLoader());
        }
    }

    private Scanner createScanner() {
        Scanner scanner = this.getScannerFromResource();
        if (scanner == null) {
            scanner = this.getScannerFromSystemProperty();
        }
        if (scanner == null) {
            log.debug("Using default URLScanner");
            scanner = new URLScanner(this);
        }
        return scanner;
    }

    private Scanner getScannerFromSystemProperty() {
        String scanners = System.getProperty("org.jboss.seam.deployment.scanners");
        if (scanners != null) {
            log.debug("Tring to load scanner from system property");
            Scanner scanner = this.loadScanner(scanners);
            if (scanner != null) {
                log.debug("Using " + scanner.getClass().getName() + " specified in /META-INF/seam-scanner.properties");
                return scanner;
            }
        }
        return null;
    }

    private Scanner getScannerFromResource() {
        try {
            String scanners = ResourceBundle.getBundle("META-INF/seam-scanner", Locale.getDefault(), this.getClassLoader()).getString("org.jboss.seam.deployment.scanners");
            log.debug("Tring to load scanner from /META-INF/seam-scanner.properties");
            Scanner scanner = this.loadScanner(scanners);
            if (scanner != null) {
                log.debug("Using " + scanner.getClass().getName() + " specified in /META-INF/seam-scanner.properties");
                return scanner;
            }
            log.debug("Unable to load any scanner from /META-INF/seam-scanner.properties");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    private Scanner loadScanner(String scanners) {
        for (String className : Strings.split(scanners, ":")) {
            Scanner scanner = this.instantiateScanner(className);
            if (scanner == null) continue;
            return scanner;
        }
        return null;
    }

    private Scanner instantiateScanner(String className) {
        try {
            Class<?> scannerClass = this.getClassLoader().loadClass(className);
            Constructor<?> constructor = scannerClass.getConstructor(DeploymentStrategy.class);
            return (Scanner)constructor.newInstance(this);
        }
        catch (ClassNotFoundException e) {
            log.trace("Unable to use " + className + " as scanner (class not found)", e);
        }
        catch (NoClassDefFoundError e) {
            log.trace("Unable to use " + className + " as scanner (dependency not found)", e);
        }
        catch (ClassCastException e) {
            log.trace("Unable to use " + className + " as scanner (class does not implement org.jboss.seam.deployment.Scanner)");
        }
        catch (InstantiationException e) {
            log.trace("Unable to instantiate scanner " + className, e);
        }
        catch (IllegalAccessException e) {
            log.trace("Unable to instantiate scanner " + className, e);
        }
        catch (SecurityException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (NoSuchMethodException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (IllegalArgumentException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (InvocationTargetException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        return null;
    }
}

