/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.security.Principal;
import java.security.acl.Group;
import javax.security.auth.Subject;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;

public abstract class RunAsOperation {
    private Principal principal = new SimplePrincipal(null);
    private Subject subject = new Subject();

    public abstract void execute();

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String[] getRoles() {
        return null;
    }

    private boolean addRole(String role) {
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!"Roles".equals(sg.getName())) continue;
            return sg.addMember((Principal)new SimplePrincipal(role));
        }
        SimpleGroup roleGroup = new SimpleGroup("Roles");
        roleGroup.addMember(new SimplePrincipal(role));
        this.getSubject().getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    public void run() {
        String[] roles = this.getRoles();
        if (roles != null) {
            for (String role : this.getRoles()) {
                this.addRole(role);
            }
        }
        Identity.instance().runAs(this);
    }
}

