/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.security.management.IdentityManagementException;
import org.jboss.seam.security.management.IdentityStore;
import org.jboss.seam.security.management.NoSuchUserException;
import org.jboss.seam.security.management.UserAccount;
import org.jboss.seam.util.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class JpaIdentityStore
implements IdentityStore {
    public static final String EVENT_ACCOUNT_CREATED = "org.jboss.seam.security.management.accountCreated";
    public static final String EVENT_ACCOUNT_AUTHENTICATED = "org.jboss.seam.security.management.accountAuthenticated";
    private String hashFunction = "MD5";
    private String hashCharset = "UTF-8";
    private String entityManagerName = "entityManager";
    private Class<? extends UserAccount> accountClass;
    private Map<String, Set<String>> roleCache;

    @Create
    public void init() {
        this.loadRoles();
    }

    protected void loadRoles() {
        List roles = this.getEntityManager().createQuery("from " + this.accountClass.getName() + " where enabled = true and accountType = :accountType").setParameter("accountType", (Object)UserAccount.AccountType.role).getResultList();
        this.roleCache = new HashMap<String, Set<String>>();
        for (UserAccount role : roles) {
            HashSet<String> memberships = new HashSet<String>();
            for (UserAccount m : role.getMemberships()) {
                memberships.add(m.getUsername());
            }
            this.roleCache.put(role.getUsername(), memberships);
        }
    }

    @Override
    public boolean createAccount(String username, String password) {
        try {
            if (this.accountClass == null) {
                throw new IdentityManagementException("Could not create account, accountClass not set");
            }
            if (this.accountExists(username)) {
                throw new IdentityManagementException("Could not create account, already exists");
            }
            UserAccount account = this.accountClass.newInstance();
            account.setAccountType(UserAccount.AccountType.user);
            account.setUsername(username);
            if (password == null) {
                account.setEnabled(false);
            } else {
                account.setPasswordHash(this.hashPassword(password, username));
                account.setEnabled(true);
            }
            this.persistAccount(account);
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_ACCOUNT_CREATED, account);
            }
            return true;
        }
        catch (Exception ex) {
            if (ex instanceof IdentityManagementException) {
                throw (IdentityManagementException)ex;
            }
            throw new IdentityManagementException("Could not create account", ex);
        }
    }

    @Override
    public boolean deleteAccount(String name) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException e) {
            return false;
        }
        this.getEntityManager().remove((Object)account);
        return true;
    }

    @Override
    public boolean grantRole(String name, String role) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException ex) {
            return false;
        }
        UserAccount roleToGrant = this.validateRole(role);
        if (account.getMemberships() == null) {
            account.setMemberships(new HashSet<UserAccount>());
        } else if (account.getMemberships().contains(roleToGrant)) {
            return false;
        }
        account.getMemberships().add(roleToGrant);
        this.mergeAccount(account);
        return true;
    }

    @Override
    public boolean revokeRole(String name, String role) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException e) {
            return false;
        }
        UserAccount roleToRevoke = this.validateRole(role);
        boolean success = account.getMemberships().remove(roleToRevoke);
        this.mergeAccount(account);
        return success;
    }

    @Override
    public boolean enableAccount(String name) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException e) {
            return false;
        }
        if (account.isEnabled()) {
            return false;
        }
        account.setEnabled(true);
        this.mergeAccount(account);
        return true;
    }

    @Override
    public boolean disableAccount(String name) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException e) {
            return false;
        }
        if (!account.isEnabled()) {
            return false;
        }
        account.setEnabled(false);
        this.mergeAccount(account);
        return true;
    }

    @Override
    public boolean changePassword(String name, String password) {
        try {
            UserAccount account = this.validateUser(name);
            account.setPasswordHash(this.hashPassword(password, name));
            this.mergeAccount(account);
            return true;
        }
        catch (NoSuchUserException e) {
            return false;
        }
    }

    @Override
    public boolean accountExists(String name) {
        try {
            UserAccount account = this.validateUser(name);
            return account != null;
        }
        catch (NoSuchUserException e) {
            return false;
        }
    }

    @Override
    public boolean isEnabled(String name) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException e) {
            return false;
        }
        return account.isEnabled();
    }

    @Override
    public List<String> getGrantedRoles(String name) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException e) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        if (account.getMemberships() != null) {
            for (UserAccount membership : account.getMemberships()) {
                if (!membership.getAccountType().equals((Object)UserAccount.AccountType.role)) continue;
                roles.add(membership.getUsername());
            }
        }
        return roles;
    }

    @Override
    public List<String> getImpliedRoles(String name) {
        UserAccount account;
        try {
            account = this.validateUser(name);
        }
        catch (NoSuchUserException e) {
            return null;
        }
        HashSet<String> roles = new HashSet<String>();
        for (UserAccount membership : account.getMemberships()) {
            if (!membership.getAccountType().equals((Object)UserAccount.AccountType.role)) continue;
            this.addRoleAndMemberships(membership.getUsername(), roles);
        }
        return new ArrayList<String>(roles);
    }

    private void addRoleAndMemberships(String role, Set<String> roles) {
        roles.add(role);
        for (String membership : this.roleCache.get(role)) {
            if (roles.contains(membership)) continue;
            this.addRoleAndMemberships(membership, roles);
        }
    }

    @Override
    public boolean authenticate(String username, String password) {
        UserAccount account = null;
        try {
            account = this.validateUser(username);
        }
        catch (NoSuchUserException ex) {
            return false;
        }
        if (account == null || !account.getAccountType().equals((Object)UserAccount.AccountType.user) || !account.isEnabled()) {
            return false;
        }
        boolean success = this.hashPassword(password, username).equals(account.getPasswordHash());
        if (success && Events.exists()) {
            Events.instance().raiseEvent(EVENT_ACCOUNT_AUTHENTICATED, account);
        }
        return success;
    }

    protected UserAccount validateUser(String name) throws NoSuchUserException {
        try {
            return (UserAccount)this.getEntityManager().createQuery("from " + this.accountClass.getName() + " where username = :username and " + "accountType = :accountType").setParameter("username", (Object)name).setParameter("accountType", (Object)UserAccount.AccountType.user).getSingleResult();
        }
        catch (NoResultException ex) {
            throw new NoSuchUserException("No such user: " + name);
        }
    }

    protected UserAccount validateRole(String name) {
        try {
            UserAccount role = (UserAccount)this.getEntityManager().createQuery("from " + this.accountClass.getName() + " where username = :username and " + "accountType = :accountType").setParameter("username", (Object)name).setParameter("accountType", (Object)UserAccount.AccountType.role).getSingleResult();
            if (!this.roleCache.containsKey(role.getUsername())) {
                HashSet<String> memberships = new HashSet<String>();
                for (UserAccount m : role.getMemberships()) {
                    memberships.add(m.getUsername());
                }
                this.roleCache.put(role.getUsername(), memberships);
            }
            return role;
        }
        catch (NoResultException ex) {
            this.roleCache.remove(name);
            throw new IdentityManagementException("No such role: " + name);
        }
    }

    @Override
    public List<String> listUsers() {
        return this.getEntityManager().createQuery("select username from " + this.accountClass.getName() + " where accountType = :accountType").setParameter("accountType", (Object)UserAccount.AccountType.user).getResultList();
    }

    @Override
    public List<String> listUsers(String filter) {
        return this.getEntityManager().createQuery("select username from " + this.accountClass.getName() + " where accountType = :accountType and lower(username) like :username").setParameter("accountType", (Object)UserAccount.AccountType.user).setParameter("username", (Object)("%" + (filter != null ? filter.toLowerCase() : "") + "%")).getResultList();
    }

    @Override
    public List<String> listRoles() {
        return this.getEntityManager().createQuery("select username from " + this.accountClass.getName() + " where accountType = :accountType").setParameter("accountType", (Object)UserAccount.AccountType.role).getResultList();
    }

    protected void persistAccount(UserAccount account) {
        this.getEntityManager().persist((Object)account);
    }

    protected UserAccount mergeAccount(UserAccount account) {
        return (UserAccount)this.getEntityManager().merge((Object)account);
    }

    public Class<? extends UserAccount> getAccountClass() {
        return this.accountClass;
    }

    public void setAccountClass(Class<? extends UserAccount> accountClass) {
        this.accountClass = accountClass;
    }

    private EntityManager getEntityManager() {
        return (EntityManager)Component.getInstance(this.entityManagerName);
    }

    public String getEntityManagerName() {
        return this.entityManagerName;
    }

    public void setEntityManagerName(String name) {
        this.entityManagerName = name;
    }

    protected String hashPassword(String password, String saltPhrase) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.hashFunction);
            md.update(saltPhrase.getBytes());
            byte[] salt = md.digest();
            md.reset();
            md.update(password.getBytes(this.hashCharset));
            md.update(salt);
            byte[] raw = md.digest();
            return new String(Hex.encodeHex(raw));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

